#ifndef _MeshProbeSheet_h
#define _MeshProbeSheet_h

//****************************************************************************
//                                                                         
// demonstration class to get probe informations with MeshViz XLM.
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshVizXLM/mapping/nodes/MoMeshPointProbe.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoGroup.h>
class MoMeshCellShape;
class SoCoordinate3;

//-------------------------------------------------------------------------------------
class MeshProbeSheet : public MoMeshPointProbe::MoProbeCallback
{
public:
  MeshProbeSheet(SoGroup* infoRoot, MoMeshCellShape* cellShape, SoCoordinate3* coord);

  void motionCallback(size_t cellId, const MeXScalardSetI& scalars, const MeXVec3dSetI& vectors);
  void setTextInfo(SbVec3f& point, size_t cellId, double value, const std::string& dataSetName = "value");
  void setInMeshSwitch(SoSwitch *inMeshSwitch = NULL)
  {
    v_inMeshSwitch = inMeshSwitch;
  }

  void switchOffText()
  {
    v_textSwitch->whichChild = SO_SWITCH_NONE;
  }

  void switchOnText();

private:
  void entersMesh();
  void leavesMesh();
  void updateValue();
  void updateValue(double probeValue, const std::string& dataSetName = "value");
  void updateCell(size_t cellId);

  bool                     v_probeInMesh;
  SoSwitch                *v_inMeshSwitch;
  MoMeshCellShape         *v_cellShape;
  SoCoordinate3           *v_coord;
  SoText2                 *v_cellIndexText;
  SoText2                 *v_probeValueText;
  SoSwitch                *v_textSwitch;
  SoGroup                 *v_infoRoot;
};


#endif

