#ifndef _MeshProbeViewer_h
#define _MeshProbeViewer_h

//****************************************************************************
//                                                                         
// demonstration class to get probe informations with MeshViz XLM.
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h> 
#include <MeshVizXLM/mapping/nodes/MoMaterial.h> 
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h> 
#include <MeshVizXLM/mapping/nodes/MoMeshPointProbe.h>
#include <MeshVizXLM/extractors/MiPointProbeUnstructured.h>

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoLevelOfDetail.h>
#include <Inventor/nodes/SoMarkerSet.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/draggers/SoJackDragger.h>

#include <DialogViz/SoDialogVizAll.h>

#include "MeshViewerComponent.h"
#include "MyMesh.h"

class MeshProbeSheet;

/******************************************************************************/
//: Demonstration class to get probe informations with MeshViz XLM.
//   This is only a demonstration class, given with source code. 
//   As it uses only some of the features of 3D-data master, the limitations
//   of this class are not necessary limitation of 3D-data Master.
// 
//   This class is a part of the MeshViewer class. It cannot be instantiate
//   apart from MeshViewer. It controls the visualization of the cell that
//   contains the position of the dragger, and it gets probe informations
//   (the value interpolated at the dragger position and the index of the cell
//   that contains this position). The probe informations are drawn at the top
//   left corner of the graphic window.
//
//   The associated dialog box controls 
//(      . the visibility of the facets of the cell that contains the probe 
//         position (see MoMeshCellShape)
//       . the visibility of the edges of the cell that contains the probe 
//         position (see MoMeshCellShape)
//       . the visibility of the node indices of the cell that contains the  
//         probe position (see MoMeshCellShape)
//       . the gap between the cell nodes and the annotated indices
//)
//   The dragger can be deconnected with a toggle button. In this case, the cell
//   that is drawn and the probe informations at the top left corner of the 
//   graphic window are not affected by the motion of the dragger.
/******************************************************************************/
class MeshProbeViewer : public MeshViewerComponent {
public:
  MeshProbeViewer();
    // Constructor.

  virtual ~MeshProbeViewer() {}

  void buildSceneGraph(const MyMesh& myMesh, 
		       SoGroup *root,
		       SoSFInt32 *colorScalarSetId,
		       SoJackDragger *dragger,
		       SoGroup *probe_text_info_group);
    // Builds the scene graph parts corresponding to the probe informations

  SoDialogComponent *buildDialogBox();
    // Creates the dialog box.
  
  void updateAllConnectedToDragger(SoJackDragger *dragger, SbVec3f plane_normal);
    // When the dragger is connected, update the text probe informations at the 
    // top left corner of the graphic window, and if the dragger as moved to 
    // another cell draw this new cell and clear the previous one.

  void preWriteAction();
    // Disables the field's connection during writing an Iv file

  void postWriteAction();
    // Re-enables the field's connection after writing an Iv file

  void setFactorValue(float val);
    // change the cell scaling factor

  void connectProbeToMouseMotion(bool connect);
  void connectProbeToDraggerMotion(bool connect);

protected:
  virtual void updateParallelMode();

private:
  void enableConnection(SoNode *node, bool flag);
  
  SoDialogGroup                   *v_DialogBox;

  MoMeshCellShape                 *v_cellShape;
  MoDrawStyle                     *v_cellDrawStyle;

  SoSwitch                        *v_cellShapeSwitch;
  SoSwitch                        *v_probeSwitch;
  SoSwitch                        *v_pickedPointSwitch;

  MoMeshPointProbe*               v_pointProbe;

  SoEventCallback                 *v_EventCallback;

  bool                            v_mouseMotion;
  bool                            v_draggerMotion;
 

  float                          v_factorValue;

  const MyMesh*               v_myMesh;
  SoJackDragger*              v_jackDragger;

  MeshProbeSheet*              v_probeSheet;
};

#endif

