#ifndef _MESH_VIEWER_COMPONENT_
#define _MESH_VIEWER_COMPONENT_
#include <Inventor/SbLinear.h>

class MeshViewerComponent {

 public:
  void connectDragger(SbBool flg) { v_IsDraggerConnected = flg; }

  virtual void setParallelMode(bool p) { v_parallel = p; updateParallelMode();}
  bool getParallelMode(void) { return v_parallel;}
  virtual void enableProgressCallback(bool /*enable*/) {}

 protected:
  MeshViewerComponent() : 
    v_IsDraggerConnected(TRUE) , 
    v_parallel(FALSE)
  {
  }

  virtual void updateParallelMode() {};


  SbBool   v_IsDraggerConnected;

  SbBool v_parallel;
};

#endif


