#ifndef _ProgressCallback_h
#define _ProgressCallback_h

#include <Inventor/STL/iostream>
#include <Inventor/STL/stack>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>
#include <Inventor/SbElapsedTime.h>

class ProgressCallback : public MiExtractorCallback
{
public:
  virtual void beginExtract(const std::string extractorName, 
    bool geomChanged, bool topoChanged, bool dataSetChanged, 
    size_t numPhases) 
  { 
    if (geomChanged || topoChanged)
      std::cout << "begin extract " << extractorName << std::endl;
    else if (dataSetChanged)
      std::cout << "begin extract " << extractorName << " dataset" << std::endl;
    m_numPhases = numPhases;
    m_extractorNames.push(extractorName);
    m_time.push(m_localTime.getElapsed());
  }
  virtual void endExtract()
  { 
    std::cout.precision(3);
    std::cout << "end extract " << m_extractorNames.top() << " in " << m_localTime.getElapsed() - m_time.top() << " seconds" << std::endl;
    m_time.pop();
    m_extractorNames.pop();
  }

  virtual bool beginPhase(size_t phase, std::string phaseName, size_t numSteps ) 
  {
    std::cout << "begin phase " << phase+1 << "/" << m_numPhases << " (" << phaseName << "), #step " << numSteps << std::endl;
    m_numSteps = numSteps;
    return true;
  }
  virtual bool endPhase()
  { 
    std::cout << "end phase " << std::endl; 
    return true;
  }
  virtual bool endStep(size_t numIterationDone) 
  {
    std::cout << "step #" << numIterationDone << "/" << m_numSteps << " : ";
    std::cout << int(std::floor(0.5+100*float(numIterationDone)/float(m_numSteps))) << " %" << std::endl;
    return true;
  }

  double getEndStepCallPeriod() { return 0.05; }

private:
  size_t m_numSteps;
  size_t m_numPhases;
  std::stack<std::string> m_extractorNames;
  SbElapsedTime m_localTime;
  std::stack<double> m_time;
};

#endif
