#ifndef _CommonAuditors_h
#define _CommonAuditors_h

#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

class CheckSwitchAllAuditor : public SoDialogCheckBoxAuditor {
  SoSwitch *sw;
public:
  CheckSwitchAllAuditor(SoSwitch *ssw) { this->sw = ssw; }
  void dialogCheckBox(SoDialogCheckBox *checkBox) {
    sw->whichChild = (checkBox->state.getValue() == TRUE)
      ? SO_SWITCH_ALL 
      : SO_SWITCH_NONE;
  }
};

class CheckSwitchAuditor : public SoDialogCheckBoxAuditor {
  SoSwitch *sw;
public:
  CheckSwitchAuditor(SoSwitch *ssw) { this->sw = ssw; }
  void dialogCheckBox(SoDialogCheckBox *checkBox) {
    sw->whichChild = (checkBox->state.getValue() == TRUE)
      ? 1 
      : 0;
  }
};

class CheckCondSwitchAuditor : public SoDialogCheckBoxAuditor {
  SoSwitch *sw;
  SoSFBool& m_condField;
public:
  CheckCondSwitchAuditor(SoSwitch *ssw, SoSFBool& field) 
    : sw(ssw), m_condField(field) 
  {
  }
  void dialogCheckBox(SoDialogCheckBox *checkBox) {
    sw->whichChild = (checkBox->state.getValue() == TRUE || m_condField.getValue()==TRUE)
      ? SO_SWITCH_ALL 
      : SO_SWITCH_NONE;
  }
};


class RealSliderAuditor : public SoDialogRealSliderAuditor {
  SoSFFloat& m_field;
public:
  RealSliderAuditor(SoSFFloat& sff) : m_field(sff) {}
  void dialogRealSlider(SoDialogRealSlider *slider) {
    m_field = slider->value;
  }
};

//---------------------------------------------------------------------------------------------------------------------
class CheckBoolAuditor : public SoDialogCheckBoxAuditor 
{
  SoSFBool& m_boolField;
public:
  CheckBoolAuditor(SoSFBool& field) : m_boolField(field)
  { 
  }
  void dialogCheckBox(SoDialogCheckBox *checkBox) 
  {
    m_boolField.setValue(checkBox->state.getValue());
  }
};

class ColoringTypeAuditor : public SoDialogChoiceAuditor 
{
  SoSFEnum& m_field;
public:
  ColoringTypeAuditor(SoSFEnum& sfe) : m_field(sfe) {}
  void dialogChoice (SoDialogChoice *dc) 
  {
    m_field.setValue((MoMaterial::ColoringType)dc->selectedItem.getValue());
  }
};

#endif
