#include "Demo.h"

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

#include "MeshViewer.h"
#include <PEBIReader.h>
#include <mesh/volumes/PEBIMesh.h>
#include <data/PEBIScalarSet.h>

#include <Inventor/STL/vector>
#include <Inventor/helpers/SbFileHelper.h>

//---------------------------------------------------------------------
Demo::Demo()
{
  m_demoPath = (SoPreferences::getString("OIVHOME",".")).getString() 
    + std::string("/examples/data/MeshVizXLM/");
}

//-----------------------------------------------------------------------------
int
Demo::run()
{
  PEBIReader reader;
  PEBIMesh& mesh = reader.generate3D(m_demoPath + "polySurf_1000.txt");
  std::vector<const MiScalardSetI*> dss;
  dss.push_back(&mesh.getScalarSet());
  std::vector<const MiVec3dSetI*> dsv;

  MiTessellator* tessellator = MiTessellator::getNewTessellatorPolyhedron();

  MeshViewer mesh_viewer;
  mesh_viewer.setCourtesyTitle("PEBI Mesh");
  mesh_viewer.show(mesh,dss,dsv,tessellator);

  delete tessellator;

  return 0;

}


