#include "Demo.h"

#include <MeshVizXLM/mapping/MoMeshViz.h>

#include <mesh/volumes/WheelHexa27Mesh.h>
#include <data/WheelDataset.h>
#include "../MeshViewer/MeshViewer.h"

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
int
Demo::run()
{
  size_t numCellR = 8;
  size_t numCellA = 8;
  size_t numCellZ = 8;

  WheelHexa27Mesh mesh(numCellR,numCellA,numCellZ);

  std::vector<const MiScalardSetI*> dss;
  std::vector<const MiVec3dSetI*> dsv;

  dss.push_back(new WheelDataset<DistanceToXAxis>(mesh));
  dss.push_back(new WheelDataset<DistanceToYAxis>(mesh));
  dss.push_back(new WheelDataset<DistanceToZAxis>(mesh));
  dss.push_back(new WheelDataset<DistanceToOrigin>(mesh));
  dss.push_back(new WheelDataset<Fx>(mesh));
  dss.push_back(new WheelDataset<Fy>(mesh));
  dss.push_back(new WheelDataset<Fz>(mesh));

  std::ostringstream title;
  title << "Generic mesh of " << numCellR << " x " << numCellA << " x " << numCellZ << " quadratic hexahedrons of 27 nodes";

  MxEdgeErrorMetricGeometry metric(0.02);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(metric);
  MeshViewer mesh_viewer;
  mesh_viewer.setCourtesyTitle(title.str().c_str());
  mesh_viewer.show(mesh,dss,dsv,tessellator,&metric);

  delete tessellator;

  return 0;
}


