#ifndef  _BenchParameters_h
#define  _BenchParameters_h

#include <Inventor/STL/vector>
#include "../Common.h"

class MiTessellator;

/*
* Contains all parameters for benches. Cannot be copied when using cellfilters.
*/

class BenchParameters
{
public:
  BenchParameters();
  ~BenchParameters();
  bool includeProgressCallback;
  bool displayPhaseTimings;
  bool includeParallel;
  bool includeSequential;
  bool includeTouchMesh;
  bool includeDeadCells;
  bool includeOnlyFiltering;
  bool includeMicroSleep;
  bool includeSecondExtractor; // profiling with 2 instances of extractor
  size_t numIteration;
  MiTessellator* tessellator;

  template < typename _CellFilterT>
  void addFilter();
  void touchFilters();
  size_t getNumFilters() const { return m_filters.size(); }
  CellFilter* getFilter(size_t i) { return m_filters[i]; }

private:
  std::vector<CellFilter*> m_filters;
};

inline
BenchParameters::BenchParameters() :
includeProgressCallback(false), displayPhaseTimings(false), includeParallel(true), includeSequential(true), includeTouchMesh(true), includeDeadCells(false), 
includeOnlyFiltering(false), includeMicroSleep(false), includeSecondExtractor(false), numIteration(5), tessellator(NULL)
{
}

inline
BenchParameters::~BenchParameters()
{
  for (size_t i = 0; i < m_filters.size(); ++i)
    delete m_filters[i];
}

template < typename _CellFilterT>
void BenchParameters::addFilter()
{
  m_filters.push_back(new _CellFilterT);
}

inline void
BenchParameters::touchFilters()
{
  for (size_t i = 0; i < m_filters.size(); ++i)
    m_filters[i]->touch();
}

#endif 


