#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
class MiCellFilterIjk;

template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class Bench_Curvilinear : public Bench<_ExtractorT,MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout> >
{
public:
  Bench_Curvilinear(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  typedef MbScalarSetIjk<double,_Layout> PerCellScalarSetType;
  typedef MbScalarSetIjk<double,_Layout> PerNodeScalarSetType;
  typedef const PerNodeScalarSetType* (MbMeshIjk<double,MbVec3d,_Layout>::*GetScalarSet)(std::string) const;

  static const GetScalarSet c_getScalarSetMethod;
  
  mutable MbSampleMeshBuilder<> m_meshBuilder;

  virtual MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;

};

template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout>
const typename Bench_Curvilinear<_ExtractorT,_Layout>::GetScalarSet Bench_Curvilinear<_ExtractorT,_Layout>::c_getScalarSetMethod = &MbMeshIjk<double,MbVec3d,_Layout>::getScalarSetIjk;

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout>
Bench_Curvilinear<_ExtractorT,_Layout>::Bench_Curvilinear(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout> >(name,"VolumeMeshCurvilinear",argc,argv)
{
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout>
inline void 
Bench_Curvilinear<_ExtractorT,_Layout>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout> >::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout>
inline size_t
Bench_Curvilinear<_ExtractorT,_Layout>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCellsI()*this->m_currentMesh->getTopology().getNumCellsJ()*this->m_currentMesh->getTopology().getNumCellsK();
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _Layout>
inline MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout>* 
Bench_Curvilinear<_ExtractorT,_Layout>::getMesh(size_t num, bool deadCells)

{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  size_t numCells = dim[0]*dim[1]*dim[2];

  NoDeadCellIjk deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellIjk*)NULL);
  MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d,_Layout>* mesh = &m_meshBuilder.getVolumeMeshCurvilinear<_Layout>(dim,MbVec3d(0),max);
  std::cout << "Curvilinear volume mesh built, num cells=" << numCells 
    << ", num nodes=" << (dim[0]+1)*(dim[1]+1)*(dim[2]+1);
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return mesh;
}

