#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
class MiCellFilterI;

template < typename _ExtractorT >
class Bench_Hexahedron : public Bench<_ExtractorT,MbVolumeMeshHexahedron<> >
{
public:
  Bench_Hexahedron(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  typedef MbScalarSetI<double> PerCellScalarSetType;
  typedef MbScalarSetI<double> PerNodeScalarSetType;
  typedef const PerNodeScalarSetType* (MbMesh<MbVec3d,double,MbVec3d>::*GetScalarSet)(std::string) const;

  static const GetScalarSet c_getScalarSetMethod;

  mutable MbSampleMeshBuilder<> m_meshBuilder; 

  virtual MbVolumeMeshHexahedron<>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;

};

template < typename _ExtractorT>
const typename Bench_Hexahedron<_ExtractorT>::GetScalarSet Bench_Hexahedron<_ExtractorT>::c_getScalarSetMethod = &MbMesh<MbVec3d,double,MbVec3d>::getScalarSet;

//-----------------------------------------------------------------------------
template < typename _ExtractorT >
Bench_Hexahedron<_ExtractorT>::Bench_Hexahedron(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbVolumeMeshHexahedron<> >(name,"VolumeMeshHexhaedron",argc,argv)
{
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline void 
Bench_Hexahedron<_ExtractorT>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbVolumeMeshHexahedron<> >::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline MbVolumeMeshHexahedron<>* 
Bench_Hexahedron<_ExtractorT>::getMesh(size_t num, bool deadCells)
{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);

  NoDeadCellI deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellI*)NULL);
  MbVolumeMeshHexahedron<>* mesh = &m_meshBuilder.getMeshHexahedron(dim,MbVec3d(0),max);
  std::cout << "Hexahedron mesh built, num cells=" << mesh->getTopology().getNumCells() 
    << ", num nodes=" << mesh->getTopology().getEndNodeId(); 
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return mesh;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline size_t
Bench_Hexahedron<_ExtractorT>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCells();
}



