#include "Bench.h"
#include "../Common.h"

#include <mesh/volumes/WheelHexa27Mesh.h>
class MiCellFilterI;

template < typename _ExtractorT >
class Bench_Hexahedron27 : public Bench<_ExtractorT,WheelHexa27Mesh>
{
public:
  Bench_Hexahedron27(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  //typedef MbScalarSetI<double> PerCellScalarSetType;
  //typedef MbScalarSetI<double> PerNodeScalarSetType;
  //typedef const PerNodeScalarSetType* (MbMesh<MbVec3d,double,MbVec3d>::*GetScalarSet)(std::string) const;

  //static const GetScalarSet c_getScalarSetMethod;

  virtual WheelHexa27Mesh* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;

};

//template < typename _ExtractorT>
//const typename Bench_Hexahedron<_ExtractorT>::GetScalarSet Bench_Hexahedron<_ExtractorT>::c_getScalarSetMethod = &MbMesh<MbVec3d,double,MbVec3d>::getScalarSet;

//-----------------------------------------------------------------------------
template < typename _ExtractorT >
Bench_Hexahedron27<_ExtractorT>::Bench_Hexahedron27(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,WheelHexa27Mesh>(name,"VolumeMeshHexahedron27",argc,argv)
{
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline void 
Bench_Hexahedron27<_ExtractorT>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,WheelHexa27Mesh>::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline WheelHexa27Mesh* 
Bench_Hexahedron27<_ExtractorT>::getMesh(size_t num, bool deadCells)
{
  if (deadCells)
    return NULL;

  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  size_t numCells = dim[0]*dim[1]*dim[2];

  WheelHexa27Mesh* mesh = new WheelHexa27Mesh(dim[0],dim[1],dim[2]);
  std::cout << "Hexahedron27 mesh built, num cells=" << numCells 
    << ", num nodes=" << mesh->getTopology().getEndNodeId() << std::endl;

  return mesh;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline size_t
Bench_Hexahedron27<_ExtractorT>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCells();
}
