#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
class MiCellFilterIjk;

template < typename _ExtractorT, MiMeshIjk::StorageLayout layout = MiMeshIjk::LAYOUT_KJI >
class Bench_HexahedronIjk : public Bench<_ExtractorT,MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout> >
{
public:
  Bench_HexahedronIjk(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  typedef MbScalarSetIjk<double> PerCellScalarSetType;
  typedef MbScalarSetI<double> PerNodeScalarSetType;
  typedef const PerNodeScalarSetType* (MbMesh<MbVec3d,double,MbVec3d>::*GetScalarSet)(std::string) const;

  static const GetScalarSet c_getScalarSetMethod;

  mutable MbSampleMeshBuilder<> m_meshBuilder;

  virtual MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;
  virtual void setUSleep(size_t us);

  MbVec3<size_t> m_nbFaults;

};

template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
const typename Bench_HexahedronIjk<_ExtractorT,layout>::GetScalarSet Bench_HexahedronIjk<_ExtractorT,layout>::c_getScalarSetMethod = &MbMesh<MbVec3d,double,MbVec3d>::getScalarSet;

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
Bench_HexahedronIjk<_ExtractorT,layout>::Bench_HexahedronIjk(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout>,CellFilter>(name,"VolumeMeshHexahedonIjk",argc,argv)
{
  m_nbFaults.setValue(2,2,0);
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
inline void 
Bench_HexahedronIjk<_ExtractorT,layout>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout>,CellFilter>::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
inline size_t
Bench_HexahedronIjk<_ExtractorT,layout>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCellsI()*this->m_currentMesh->getTopology().getNumCellsJ()*this->m_currentMesh->getTopology().getNumCellsK();
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
inline MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout>* 
Bench_HexahedronIjk<_ExtractorT,layout>::getMesh(size_t num, bool deadCells)

{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  size_t numCells = dim[0]*dim[1]*dim[2];

  NoDeadCellIjk deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellIjk*)NULL);
  MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,layout>* mesh = &m_meshBuilder.getHexahedronMeshIjk<layout>(dim,MbVec3d(0),max,m_nbFaults);
  std::cout << "HexahedronIjk mesh built, num cells=" << numCells 
    << ", num nodes=" << mesh->getTopology().getEndNodeId();
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return mesh;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout layout>
inline void
Bench_HexahedronIjk<_ExtractorT,layout>::setUSleep(size_t us)
{
  MbHexahedronTopologyExplicitIjk<layout>::s_microsleep = us;
}

template <MiMeshIjk::StorageLayout layout>
size_t MbHexahedronTopologyExplicitIjk<layout>::s_microsleep = 0;
