#ifndef _Bench_Mesh_h
#define _Bench_Mesh_h

#include "Bench_Regular.h"
#include "Bench_Rectilinear.h"
#include "Bench_Curvilinear.h"
#include "Bench_HexahedronIjk.h"
#include "Bench_VertexHexahedronIjk.h"
#include "Bench_Hexahedron.h"
#include "Bench_Hexahedron27.h"
#include "Bench_Tetrahedron.h"

enum MeshImpl {
  REGULAR,
  RECTILINEAR,
  CURVILINEAR,
  HEXAHEDRONIJK,
  VERTEXHEXAHEDRONIJK,
  HEXAHEDRON,
  HEXAHEDRON27,
  TETRAHEDRON,
};

template < typename _ExtractT, MeshImpl _MeshT, MiMeshIjk::StorageLayout layout = MiMeshIjk::LAYOUT_UNKNOWN>
class Bench_Mesh;

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,REGULAR,layout> : public Bench_Regular<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Regular<_ExtractT>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,RECTILINEAR,layout> : public Bench_Rectilinear<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Rectilinear<_ExtractT>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,CURVILINEAR,layout> : public Bench_Curvilinear<_ExtractT,layout>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Curvilinear<_ExtractT,layout>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,HEXAHEDRONIJK,layout> : public Bench_HexahedronIjk<_ExtractT,layout>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_HexahedronIjk<_ExtractT,layout>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,VERTEXHEXAHEDRONIJK,layout> : public Bench_VertexHexahedronIjk<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_VertexHexahedronIjk<_ExtractT>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,HEXAHEDRON,layout> : public Bench_Hexahedron<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Hexahedron<_ExtractT>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,TETRAHEDRON,layout> : public Bench_Tetrahedron<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Tetrahedron<_ExtractT>(name,argc,argv) {}
};

template < typename _ExtractT, MiMeshIjk::StorageLayout layout>
class Bench_Mesh<_ExtractT,HEXAHEDRON27,layout> : public Bench_Hexahedron27<_ExtractT>
{
public:
  Bench_Mesh(const std::string& name, int argc, char* argv[]) : 
  Bench_Hexahedron27<_ExtractT>(name,argc,argv) {}
};

#endif

