#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
class MiCellFilterIjk;

template < typename _ExtractorT >
class Bench_Rectilinear : public Bench<_ExtractorT,MbVolumeMeshRectilinear<> >
{
public:
  Bench_Rectilinear(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  typedef MbScalarSetIjk<double> PerCellScalarSetType;
  typedef MbScalarSetIjk<double> PerNodeScalarSetType;
  typedef const PerNodeScalarSetType* (MbMeshIjk<double,MbVec3d>::*GetScalarSet)(std::string) const;

  static const GetScalarSet c_getScalarSetMethod;
  
  mutable MbSampleMeshBuilder<> m_meshBuilder;

  virtual MbVolumeMeshRectilinear<>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;

};

template < typename _ExtractorT>
const typename Bench_Rectilinear<_ExtractorT>::GetScalarSet Bench_Rectilinear<_ExtractorT>::c_getScalarSetMethod = &MbMeshIjk<double,MbVec3d>::getScalarSetIjk;

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
Bench_Rectilinear<_ExtractorT>::Bench_Rectilinear(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbVolumeMeshRectilinear<> >(name,"VolumeMeshRectilienar",argc,argv)
{
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline void 
Bench_Rectilinear<_ExtractorT>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbVolumeMeshRectilinear<> >::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline size_t
Bench_Rectilinear<_ExtractorT>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCellsI()*this->m_currentMesh->getTopology().getNumCellsJ()*this->m_currentMesh->getTopology().getNumCellsK();
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline MbVolumeMeshRectilinear<>* 
Bench_Rectilinear<_ExtractorT>::getMesh(size_t num, bool deadCells)

{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  size_t numCells = dim[0]*dim[1]*dim[2];

  NoDeadCellIjk deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellIjk*)NULL);
  MbVolumeMeshRectilinear<>* mesh = &m_meshBuilder.getVolumeMeshRectilinear(dim,MbVec3d(0),max);
  std::cout << "Rectilinear volume mesh built, num cells=" << numCells 
    << ", num nodes=" << (dim[0]+1)*(dim[1]+1)*(dim[2]+1);
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return mesh;
}

