#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
class MiCellFilterI;

template < typename _ExtractorT >
class Bench_Tetrahedron : public Bench<_ExtractorT,MbVolumeMeshTetrahedron<> >
{
public:
  Bench_Tetrahedron(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  protected:
  typedef MbScalarSetI<double> PerCellScalarSetType;
  typedef MbScalarSetI<double> PerNodeScalarSetType;
  typedef const PerNodeScalarSetType* (MbMesh<MbVec3d,double,MbVec3d>::*GetScalarSet)(std::string) const;

  static const GetScalarSet c_getScalarSetMethod;

  mutable MbSampleMeshBuilder<> m_meshBuilder; 

  virtual MbVolumeMeshTetrahedron<>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;

  CellFilter* getFilter(size_t f, std::string& fname, size_t usleep);

};

template < typename _ExtractorT>
const typename Bench_Tetrahedron<_ExtractorT>::GetScalarSet Bench_Tetrahedron<_ExtractorT>::c_getScalarSetMethod = &MbMesh<MbVec3d,double,MbVec3d>::getScalarSet;

//-----------------------------------------------------------------------------
template < typename _ExtractorT >
Bench_Tetrahedron<_ExtractorT>::Bench_Tetrahedron(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbVolumeMeshTetrahedron<> >(name,"VolumeMeshTetrahedron",argc,argv)
{
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline void 
Bench_Tetrahedron<_ExtractorT>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbVolumeMeshTetrahedron<> >::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline CellFilter*
Bench_Tetrahedron<_ExtractorT>::getFilter(size_t f, std::string& fname, size_t usleep)
{
  CellFilter* filter = Bench<_ExtractorT,MbVolumeMeshTetrahedron<> >::getFilter(f,fname,usleep);
  if (filter)
    filter->dimension *= 6;
  return filter;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline MbVolumeMeshTetrahedron<>* 
Bench_Tetrahedron<_ExtractorT>::getMesh(size_t num, bool deadCells)
{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  
  NoDeadCellI deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellI*)NULL);
  MbVolumeMeshTetrahedron<>* mesh = &m_meshBuilder.getMeshTetrahedron(dim,MbVec3d(0),max);
  std::cout << "Tetrahedron mesh built, num cells=" << mesh->getTopology().getNumCells() 
    << ", num nodes=" << mesh->getTopology().getEndNodeId();
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return mesh;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT>
inline size_t
Bench_Tetrahedron<_ExtractorT>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCells();
}
