#include "Bench.h"
#include "../Common.h"

#include <MbSampleMeshBuilder.h>
#include <mesh/volumes/MbVertexHexahedronMeshIjk.h>
class MiCellFilterIjk;

template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT = MiMeshIjk::LAYOUT_KJI >
class Bench_VertexHexahedronIjk : public Bench<_ExtractorT,MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT> >
{
public:
  Bench_VertexHexahedronIjk(const std::string& name, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

protected:
  typedef MbScalarSetIjk<double> PerCellScalarSetType;
  //typedef MbScalarSetI<double> PerNodeScalarSetType;
  //typedef const PerNodeScalarSetType* (MbMesh<MbVec3d,double,MbVec3d>::*GetScalarSet)(std::string) const;

  //static const GetScalarSet c_getScalarSetMethod;

  mutable MbSampleMeshBuilder<> m_meshBuilder;

  virtual MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT>* getMesh(size_t num, bool deadCells);

private:
  virtual size_t    getNumCells() const;
  virtual void setUSleep(size_t us);

  MbVec3<size_t> m_nbFaults;

  MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT>* m_mesh;

};

//template < typename _ExtractorT>
//const typename Bench_VertexHexahedronIjk<_ExtractorT>::GetScalarSet Bench_VertexHexahedronIjk<_ExtractorT>::c_getScalarSetMethod = &MbMesh<MbVec3d,double,MbVec3d>::getScalarSet;

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT>
Bench_VertexHexahedronIjk<_ExtractorT,_LAYOUT>::Bench_VertexHexahedronIjk(const std::string& name, int argc, char* argv[]) : 
Bench<_ExtractorT,MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT> >(name,"VolumeMeshVertexHexahedronIjk",argc,argv)
{
  m_nbFaults.setValue(2,2,0);
  m_meshBuilder.disableDataSets(true);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT>
inline void 
Bench_VertexHexahedronIjk<_ExtractorT,_LAYOUT>::run(size_t* dims, size_t num, BenchParameters& params)
{
  this->m_dims = dims;
  Bench<_ExtractorT,MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT> >::run(num,params);
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT>
inline size_t
Bench_VertexHexahedronIjk<_ExtractorT,_LAYOUT>::getNumCells() const
{
  return this->m_currentMesh->getTopology().getNumCellsI()*this->m_currentMesh->getTopology().getNumCellsJ()*this->m_currentMesh->getTopology().getNumCellsK();
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT>
inline MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,_LAYOUT>* 
Bench_VertexHexahedronIjk<_ExtractorT,_LAYOUT>::getMesh(size_t num, bool deadCells)

{
  MbVec3<size_t> dim(this->m_dims[num]);
  MbVec3d max(this->m_dims[num]);
  size_t numCells = dim[0]*dim[1]*dim[2];

  NoDeadCellIjk deadCellsFctor;
  if (deadCells)
    m_meshBuilder.addDeadCellFctor(&deadCellsFctor);
  else
    m_meshBuilder.addDeadCellFctor((MyDeadCellIjk*)NULL);

  m_mesh = new MbVertexHexahedronMeshIjk<MbVec3d,double,MbVec3d,MiMeshIjk::LAYOUT_KJI>(m_meshBuilder.getHexahedronMeshIjk<MiMeshIjk::LAYOUT_KJI>(dim,MbVec3d(0),max,m_nbFaults));
  std::cout << "Vertex HexahedronIjk mesh built, num cells=" << numCells;
  if (deadCells)
    std::cout << " with dead cells" << std::endl;
  else
    std::cout << std::endl;

  return m_mesh;
}

//-----------------------------------------------------------------------------
template < typename _ExtractorT, MiMeshIjk::StorageLayout _LAYOUT>
inline void
Bench_VertexHexahedronIjk<_ExtractorT,_LAYOUT>::setUSleep(size_t us)
{
  MbHexahedronTopologyExplicitIjk<_LAYOUT>::s_microsleep = us;
}


