#ifndef _ExtractorTraits_h
#define _ExtractorTraits_h

#include "Bench_Mesh.h"

// Extractor classes
class MiSkinExtractUnstructured;
class MiSkinExtractHexahedronIjk;
class MiSkinExtractIjk;
class MiIsosurfExtractUnstructured;
class MiIsosurfExtractHexahedronIjk;
class MiIsosurfExtractIjk;
class MiPlaneSliceExtractUnstructured;
class MiPlaneSliceExtractHexahedronIjk;
class MiPlaneSliceExtractIjk;
class MiSphereSliceExtractUnstructured;
class MiSphereSliceExtractHexahedronIjk;
class MiSphereSliceExtractIjk;
class MiCylinderSliceExtractUnstructured;
class MiCylinderSliceExtractHexahedronIjk;
class MiInterpolatedLogicalSliceExtract;
class MiInterpolatedLogicalSliceExtractHexahedronIjk;
class MiCylinderSliceExtractIjk;
class MiCellExtractUnstructured;
class MiLineCellExtractI;
class MiLineCellExtractUnstructured;
class MiCellExtractHexahedronIjk;
class MiCellExtractIjk;
class MiCellExtractIj;
class MiTessellatedVolumeExtract;
class MiTessellatedSurfaceExtract;
class MiTessellatedLineExtract;
class MiClipPointExtract;
class MiOutlineExtractUnstructured;
class MiOutlineExtractHexahedronIjk;
class MiOutlineExtractIjk;
class MiOutlineExtractIj;

template <MeshImpl _MeshT>
struct ExtractorTraits;

template<>
struct ExtractorTraits<HEXAHEDRON>
{
  typedef MiVolumeMeshUnstructured MeshType;
  typedef MiSkinExtractUnstructured   SkinExtractT;
  typedef MiIsosurfExtractUnstructured  IsosurfExtractT;
  typedef MiPlaneSliceExtractUnstructured PlaneSliceExtractT;
  typedef MiSphereSliceExtractUnstructured SphereSliceExtractT;
  typedef MiCylinderSliceExtractUnstructured CylinderSliceExtractT;
  typedef MiTessellatedVolumeExtract  TessellationExtractT;
  typedef MiOutlineExtractUnstructured OutlineExtractT;
};

template<>
struct ExtractorTraits<HEXAHEDRON27> : public ExtractorTraits<HEXAHEDRON>
{
};

template<>
struct ExtractorTraits<TETRAHEDRON> : public ExtractorTraits<HEXAHEDRON>
{
};

template<>
struct ExtractorTraits<HEXAHEDRONIJK>
{
  typedef MiVolumeMeshHexahedronIjk MeshType;
  typedef MiSkinExtractHexahedronIjk SkinExtractT;
  typedef MiIsosurfExtractHexahedronIjk IsosurfExtractT;
  typedef MiPlaneSliceExtractHexahedronIjk PlaneSliceExtractT;
  typedef MiSphereSliceExtractHexahedronIjk SphereSliceExtractT;
  typedef MiCylinderSliceExtractHexahedronIjk CylinderSliceExtractT;
  typedef MiInterpolatedLogicalSliceExtractHexahedronIjk InterpolatedLogicalSliceExtractT;
  typedef MiCellExtractHexahedronIjk   CellExtractT;
  typedef MiOutlineExtractHexahedronIjk OutlineExtractT;
};

template<>
struct ExtractorTraits<VERTEXHEXAHEDRONIJK>
{
  typedef MiVolumeMeshVertexHexahedronIjk MeshType;
  typedef MiSkinExtractIjk SkinExtractT;
  typedef MiOutlineExtractIjk OutlineExtractT;
};

template<>
struct ExtractorTraits<REGULAR>
{
  typedef MiVolumeMeshRegular MeshType;
  typedef MiSkinExtractIjk   SkinExtractT;
  typedef MiIsosurfExtractIjk IsosurfExtractT;
  typedef MiPlaneSliceExtractIjk PlaneSliceExtractT;
  typedef MiSphereSliceExtractIjk SphereSliceExtractT;
  typedef MiCylinderSliceExtractIjk CylinderSliceExtractT;
  typedef MiInterpolatedLogicalSliceExtract InterpolatedLogicalSliceExtractT;
  typedef MiCellExtractIjk   CellExtractT;
  typedef MiOutlineExtractIjk OutlineExtractT;
};

template<>
struct ExtractorTraits<RECTILINEAR> : public ExtractorTraits<REGULAR>
{
  typedef MiVolumeMeshRectilinear MeshType;
};

template<>
struct ExtractorTraits<CURVILINEAR> : public ExtractorTraits<REGULAR>
{
  typedef MiVolumeMeshCurvilinear MeshType;
};

#endif

