#pragma once

#include <string>
#include <vector>

#include <Inventor/SbElapsedTime.h>

class Gauge {
  std::vector<std::string>  stage_names_;
  std::vector<size_t>       stage_mems_;
  std::vector<double>       stage_times_;
  SbElapsedTime      m_elapsedTime;

public:
  Gauge();
  ~Gauge();

  static std::string memToString(double mem);
  static std::string timeToString(double eltime);

  int sample(const std::string& tag = "", bool display = false);
  void reset(const std::string& tag = "init");
  std::string report() const;
  std::string reportStat(std::ostringstream& result, const char* sep) const;
};

