/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MyPolygonCell_H
#define _MyPolygonCell_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>
#include <MeshVizXLM/extrmesh/cell/MeXSurfaceCell.h>

/**
*/
class MyPolygonCell : public MeXSurfaceCell
{
public:
  /** 
  * Construct a emty polygon.
  */
  MyPolygonCell() {}

  /** 
  * Construct a polygon defined by its list of indices.
  */
  template <typename _NodeIdIter>
  MyPolygonCell(_NodeIdIter beginId, _NodeIdIter endId);

  /** 
  * Construct a polygon defined by a subsequent list of indices.
  * Used by a prototype of tessellator.
  */
  MyPolygonCell(size_t firstId, size_t numNodes);

  /** 
  * Construct a polygon defined by a facet of a cell. (avoid multiple copies of indices)
  */
  MyPolygonCell(const MiVolumeCell* cell, size_t facetId);

  /** 
  * replace the list of indices.
  */
  template <typename _NodeIdIter>
  void setIndexValues(_NodeIdIter beginId, _NodeIdIter endId);

  /**
  * add an offset to every node indices
  */
  void offsetIndexValues(size_t offset);

  /**
  * Gets the number of edges.
  */
  virtual size_t getNumEdges() const; 

  /**
  * Gets the number of nodes.
  */
  virtual size_t getNumNodes() const; 

  virtual size_t getNodeIndex(size_t nod) const;

  virtual double getRelativeSize(const MiGeometryI* meshGeometry) const ;

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const;

  /*
  * compute area for any irregular polygon (convex and concave).
  */
  double getArea(const MiGeometryI* meshGeometry) const;

  /*
  * compute the average normal to a planar or almost-planar polygon using Newell's method
  */
  MbVec3d getNormal(const MiGeometryI* meshGeometry) const;

protected:
  /**
  * Defines a specialized output on stream for MbPolygonCell
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  size_t m_nodeIds[4];

};

//-----------------------------------------------------------------------------
template <typename _NodeIdIter>
inline
MyPolygonCell::MyPolygonCell(_NodeIdIter beginId, _NodeIdIter endId)
{
}

//-----------------------------------------------------------------------------
inline
MyPolygonCell::MyPolygonCell(size_t firstNodeId, size_t numNodes)
{

}

//-----------------------------------------------------------------------------
inline
MyPolygonCell::MyPolygonCell(const MiVolumeCell* cell, size_t facetId)
{
}

//-----------------------------------------------------------------------------
template <typename _NodeIdIter>
inline void
MyPolygonCell::setIndexValues(_NodeIdIter beginId, _NodeIdIter endId)
{
}

//-----------------------------------------------------------------------------
inline void
MyPolygonCell::offsetIndexValues(size_t offset)
{
}

//-----------------------------------------------------------------------------
inline size_t 
MyPolygonCell::getNumEdges() const
{
  return 4;
}

//-----------------------------------------------------------------------------
inline size_t 
MyPolygonCell::getNumNodes() const
{
  return 4;
}

//-----------------------------------------------------------------------------
inline size_t 
MyPolygonCell::getNodeIndex(size_t nod) const
{
  return m_nodeIds[nod];
}

//-----------------------------------------------------------------------------
inline std::ostream& 
MyPolygonCell::toStream(std::ostream& s) const
{
  s << "Polygon Cell (";
  s << ")";
  return s;
}

#include <MeshVizXLM/extractors/MxPolygonCellExtract.h>

//------------------------------------------------------------------------------
double 
  MyPolygonCell::getRelativeSize(const MiGeometryI* meshGeometry) const
{
  return MxPolygonCellExtract::getLongestEdgeLength(*meshGeometry,this);
}

//------------------------------------------------------------------------------
bool 
  MyPolygonCell::isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
{
  return MxPolygonCellExtract::isPointInsideCell(meshGeometry,this,point,weights);
}

//---------------------------------------------------------------------------------------------------------------------
MbVec3d 
  MyPolygonCell::getNormal(const MiGeometryI* meshGeometry) const
{
  return MxPolygonCellExtract::getNormal(*meshGeometry,this);
}

//---------------------------------------------------------------------------------------------------------------------
double MyPolygonCell::getArea(const MiGeometryI* meshGeometry) const
{
  return MxPolygonCellExtract::getArea(*meshGeometry,this);
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


