#include "Bench_Mesh.h"
#include "../Common.h"
#include <MeshVizXLM/extractors/MiInterpolatedLogicalSliceExtract.h>
#include <MeshVizXLM/extractors/MiInterpolatedLogicalSliceExtractUnstructuredIjk.h>
#include "ExtractorTraits.h"

template <MeshImpl _MeshT>
class Extract : public ExtractorTraits<_MeshT>::InterpolatedLogicalSliceExtractT
{
public:
  static Extract* getNewInstance(const typename ExtractorTraits<_MeshT>::MeshType& mesh, bool parallel, MiTessellator*)
  {
    return (Extract*) ExtractorTraits<_MeshT>::InterpolatedLogicalSliceExtractT::getNewInstance(mesh, parallel);
  }
};

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class Bench_InterpolatedLogicalSlice : public Bench_Mesh < Extract<_MeshT>, _MeshT, _Layout >
{
  typedef Extract<_MeshT> _ExtractT;
public:
  Bench_InterpolatedLogicalSlice(int argc, char* argv[]);

  MiMesh::Dimension sliceAxis;

private:
  virtual void extract(Extract<_MeshT>* extractor, const typename Bench_Mesh<_ExtractT, _MeshT>::FilterType* cellFilter) const;

};

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
Bench_InterpolatedLogicalSlice<_MeshT, _Layout>::Bench_InterpolatedLogicalSlice(int argc, char* argv[]) :
Bench_Mesh<_ExtractT, _MeshT, _Layout>("InterpolatedLogicalSlice", argc, argv), sliceAxis(MiMesh::DIMENSION_I)
{
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_InterpolatedLogicalSlice<_MeshT, _Layout>::extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT, _MeshT>::FilterType* cellFilter) const
{
  double sliceValue;
  switch (sliceAxis)
  {
  case MiMesh::DIMENSION_I:
    sliceValue = this->m_currentMesh->getTopology().getNumCellsI() / 2.0;
  case MiMesh::DIMENSION_J:
    sliceValue = this->m_currentMesh->getTopology().getNumCellsJ() / 2.0;
  case MiMesh::DIMENSION_K:
  default:
    sliceValue = this->m_currentMesh->getTopology().getNumCellsK() / 2.0;
  };
  extractor->extractInterpolatedLogicalSlice(sliceAxis, sliceValue, cellFilter);
}
