#include "Bench_InterpolatedLogicalSlice.h"

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK
  typedef Bench_InterpolatedLogicalSlice<HEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> BenchInterpolatedLogicalSlice;

  BenchInterpolatedLogicalSlice bench(argc, argv);
  bench.sliceAxis = MiMesh::DIMENSION_I;
  // reduce number of threads
  //BenchInterpolatedLogicalSlice:setNumThreads(4);

  BenchParameters params;
  // Select Filters
  //params.addFilter<NoCellFilterIjk>();
  //params.addFilter<HalfCellFilterIjk>();
  //params.addFilter<BorderCellFilterIjk>();
  //params.addFilter<SliceICellFilterIjk>();
  //params.addFilter<SliceKCellFilterIjk>();
  //params.addFilter<CrossCellFilterIjk>();
  //params.addFilter<SpreadHalfCellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 4;
  params.includeSequential = true;
  params.includeParallel = true;
  params.includeTouchMesh = true;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;

  size_t dims[5] = { 100, 144, 220, 370, 470 };
  bench.run(dims,5,params);

  return 0;
}


