#include "Bench_Mesh.h"
#include "../Common.h"
#include <MeshVizXLM/extractors/MiIsosurfExtractUnstructured.h>
#include <MeshVizXLM/extractors/MiIsosurfExtractHexahedronIjk.h>
#include <MeshVizXLM/extractors/MiIsosurfExtractIjk.h>
#include "ExtractorTraits.h"

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class Bench_Isosurf : public Bench_Mesh<typename ExtractorTraits<_MeshT>::IsosurfExtractT,_MeshT,_Layout>
{
  typedef typename ExtractorTraits<_MeshT>::IsosurfExtractT _ExtractT;
public:
  typedef MbScalarFunctor<double> ScalarFctor;
  Bench_Isosurf(const std::vector<ScalarFctor*>& scalarFctors, int argc, char* argv[]);

  void run(size_t* dims, size_t num, BenchParameters& params);

private:
  typedef typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::PerNodeScalarSetType IsoScalarSetType;

  virtual void writeCaseInfo(std::ostringstream& result) const;
  virtual typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::MeshType* getMesh(size_t num, bool deadCells);

  virtual void extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::FilterType* cellFilter) const;
  virtual CellFilter* getFilter(size_t /*i*/, std::string& /*fname*/, size_t /*usleep*/);

  mutable IsoScalarSetType*  m_isoScalar;
  double        m_isoValue;

  const std::vector<ScalarFctor*>& m_scalarFctorList;
};
//-----------------------------------------------------------------------------

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
Bench_Isosurf<_MeshT,_Layout>::Bench_Isosurf(const std::vector<ScalarFctor*>& scalarFctors, int argc, char* argv[]) : 
Bench_Mesh<_ExtractT,_MeshT,_Layout>("Isosurface",argc,argv), m_isoScalar(NULL), m_scalarFctorList(scalarFctors)
{
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void 
Bench_Isosurf<_MeshT,_Layout>::writeCaseInfo(std::ostringstream &results) const
{
  results << this->m_sep << std::setw(8) << m_isoScalar->getName();
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void 
Bench_Isosurf<_MeshT,_Layout>::run(size_t* dims, size_t num, BenchParameters& params)
{
  size_t numCase = num * m_scalarFctorList.size();
  Bench_Mesh<_ExtractT,_MeshT,_Layout>::run(dims,numCase,params);
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
typename Bench_Mesh<typename ExtractorTraits<_MeshT>::IsosurfExtractT,_MeshT,_Layout>::MeshType* 
Bench_Isosurf<_MeshT,_Layout>::getMesh(size_t num, bool deadCells)
{
  size_t numScalar = num % m_scalarFctorList.size();
  size_t numMesh = (size_t) num / m_scalarFctorList.size();

  this->m_meshBuilder.clearScalarFctors();
  this->m_meshBuilder.addScalarFctor(m_scalarFctorList[numScalar],m_scalarFctorList[numScalar]->getName());

  typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::MeshType* mesh = Bench_Mesh<_ExtractT,_MeshT,_Layout>::getMesh(numMesh,deadCells);

  m_isoScalar = const_cast<IsoScalarSetType*>((mesh->*Bench_Mesh<_ExtractT,_MeshT,_Layout>::c_getScalarSetMethod)(m_scalarFctorList[numScalar]->getName()));
  m_isoValue = m_isoScalar->getMin() + (( m_isoScalar->getMax() - m_isoScalar->getMin() ) / 3.0);

  return mesh;
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Isosurf<_MeshT,_Layout>::extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::FilterType* cellFilter) const
{
  m_isoScalar->touch();
  extractor->extractIsovalue(m_isoValue,*m_isoScalar,cellFilter);
}


//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
inline CellFilter*
Bench_Isosurf<_MeshT,_Layout>::getFilter(size_t f, std::string& fname, size_t usleep)
{
  CellFilter* filter =  Bench_Mesh<_ExtractT,_MeshT,_Layout>::getFilter(f,fname,usleep);
  filter->dimension = this->m_dims[this->m_currentCase/m_scalarFctorList.size() ];
  return filter;
}
