#include "Bench_Isosurf.h"
#include <MeshVizXLM/tessellator/MiTessellator.h>

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  // reduce number of threads
  //Bench_Isosurf<meshT>:setNumThreads(4);

  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK, HEXAHEDRON, TETRAHEDRON
  // storage layout is effective on all type of meshes except unstructured ones (HEXAHEDRON)
  typedef Bench_Isosurf<HEXAHEDRON,MiMeshIjk::LAYOUT_KJI> BenchIsosurface;


  // Add iso datasets
  std::vector<BenchIsosurface::ScalarFctor*> scalarFctorList;
  scalarFctorList.push_back(new MbXFctor<double>);
  scalarFctorList.push_back(new MbSphereFctor<double>);

  BenchIsosurface bench(scalarFctorList,argc,argv);

  BenchParameters params;
  // Select Filters
  params.addFilter<NoCellFilterIjk>();
  params.addFilter<HalfCellFilterIjk>();
  params.addFilter<BorderCellFilterIjk>();
  params.addFilter<SliceICellFilterIjk>();
  //params.addFilter<SliceKCellFilterIjk>();
  //params.addFilter<CrossCellFilterIjk>();
  //params.addFilter<SpreadHalfCellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 4;
  params.includeSequential = true;
  params.includeParallel = true;
  params.includeTouchMesh = true;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;
  //params.tessellator = MiTessellator::getNewTessellatorPolyhedron();

  size_t dims[5] = { 100, 144, 220, 370, 470 };
  bench.run(dims,5,params);

  for (size_t i=0; i < scalarFctorList.size(); ++i)
    delete scalarFctorList[i];

  return 0;
}


