#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshVizXLM/MiMeshViz.h>

#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/extractors/MiLogicalSliceExtractHexahedronIjk.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

#include "MeshSceneGraph.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM logical slice extraction"

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

SbElapsedTime localTime;

class MyCellFilter : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t k) const 
  { 
    // Compute any random function 
    return (((i*j+k)%7) != 0);
  }
  virtual size_t getTimeStamp() const { return 0; }
};

#define NUM_CELL_I 200
#define NUM_CELL_J 200
#define NUM_CELL_K 120
 
//-----------------------------------------------------------------------------
int
main(int, char **)
{
  MiMeshViz::init();
  
  MbSampleMeshBuilder<MbVec3d,double> meshBuidler;
  MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>& mesh1 = meshBuidler.getHexahedronMeshIjk(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));

  cout << "mesh built, num cells" << mesh1.getTopology().getNumCellsI()*mesh1.getTopology().getNumCellsJ()*mesh1.getTopology().getNumCellsK() << endl;


  MiLogicalSliceExtractHexahedronIjk* logicalSliceExtract = MiLogicalSliceExtractHexahedronIjk::getNewInstance(mesh1);

  double t1 = localTime.getElapsed();

  logicalSliceExtract->extractLogicalSlice(MiMesh::DIMENSION_I, 0, false, new MyCellFilter);

  // index out of range: clamp to the dimension.
  logicalSliceExtract->extractLogicalSlice(MiMesh::DIMENSION_J, 2000, true, NULL);

  logicalSliceExtract->extractLogicalSlice(MiMesh::DIMENSION_K, 80, false, new MyCellFilter);

  double t2 = localTime.getElapsed();

  cout << "Time to extract 3 logical slices on MiVolumeMeshHexahedronIjk:" << t2-t1 << endl;

  delete logicalSliceExtract;

  MiMeshViz::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif
