#ifndef _Mesh2DSCENEGRAPH_H
#define _Mesh2DSCENEGRAPH_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <Inventor/STL/vector>

class SoSeparator;

class Mesh2DSceneGraph
{
public:
  Mesh2DSceneGraph(std::vector<const MiSurfaceMeshUnstructured* >& skinMeshList);
  
  SoSeparator* getRoot() const {return m_root; }
    
protected:
  SoSeparator* buildMesh2DSceneGraph(const MiSurfaceMeshUnstructured* mesh);
  void insertCoordinates(SoSeparator* root,const MiSurfaceMeshUnstructured* mesh);
  void insertIndices(SoSeparator* root,const MiSurfaceMeshUnstructured* mesh);

  SoSeparator *m_root;
  const std::vector<const MiSurfaceMeshUnstructured* >& m_skinMeshList;
};

#endif


