#include "Mesh2DSceneGraph.h"
#include "MeshSceneGraph.h"

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>


//-----------------------------------------------------------------------------
SoSeparator*  
MeshSceneGraph::buildSceneGraph()
{
  SoSeparator* root = new SoSeparator;

  root->ref() ;
  root->addChild(new SoPerspectiveCamera);

  SoMaterial* mat = new SoMaterial();
  mat->diffuseColor.setValue(SbColor(1.0f,1.0f,1.0f));
  root->addChild(mat);

  SoShapeHints *shapeHints = new SoShapeHints;
  shapeHints->vertexOrdering = SoShapeHints::CLOCKWISE;
  root->addChild(shapeHints);

  Mesh2DSceneGraph isos(m_skinMeshList);
  root->addChild(isos.getRoot());

  return root;
}



