#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshVizXLM/MiMeshViz.h>

#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/extractors/MiLogicalSliceExtractRegular.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

#include "MeshSceneGraph.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM logical slice extraction"

//void viewMesh(const MiVolumeMeshRegular& volmesh, std::vector<const MiSurfaceMeshRegular* >& meshList);

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

SbElapsedTime localTime;

class MyCellFilter : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t k) const 
  { 
    // Compute any random function 
    return (((i*j+k)%7) != 0);
  }
  virtual size_t getTimeStamp() const { return 0; }
};

#define NUM_CELL_I 10
#define NUM_CELL_J 10
#define NUM_CELL_K 10
 
//-----------------------------------------------------------------------------
int
main(int, char **)
{
  SoDB::init();
  MiMeshViz::init();
  
  MbSampleMeshBuilder<MbVec3d,double> meshBuidler;
  MbVolumeMeshRegular<double,double,MbVec3d>& mesh = meshBuidler.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));


  std::vector<const MiSurfaceMeshRegular* > skinMeshList;

  cout << "mesh built, num cells I =" << mesh.getTopology().getNumCellsI() 
       << ", num cells J =" << mesh.getTopology().getNumCellsJ()
       << ", num cells K =" << mesh.getTopology().getNumCellsK() << endl;


  double t1 = localTime.getElapsed();

  MiLogicalSliceExtractRegular* logicalSliceExtractI = MiLogicalSliceExtractRegular::getNewInstance(mesh);
  skinMeshList.push_back(&logicalSliceExtractI->extractLogicalSlice(MiMesh::DIMENSION_I, 0, false, new MyCellFilter));
  const MiScalardSetIj& extractDataSet = logicalSliceExtractI->extractScalarSet(*mesh.getScalarSetIjk("$MyScalarSet"));
  const MiVec3dSetIj& extractVec3dSet = logicalSliceExtractI->extractVec3Set(*mesh.getVec3SetIjk("$MyGeometry"));
  cout << "Scalar set: " << endl;
  cout << extractDataSet << endl;
  cout << "Vector set: " << endl;
  cout << extractVec3dSet << endl;

  MiLogicalSliceExtractRegular* logicalSliceExtractJ = MiLogicalSliceExtractRegular::getNewInstance(mesh);
  // index out of range: clamp to the dimension.
  skinMeshList.push_back(&logicalSliceExtractJ->extractLogicalSlice(MiMesh::DIMENSION_J, 2000, true, NULL));

  MiLogicalSliceExtractRegular* logicalSliceExtractK = MiLogicalSliceExtractRegular::getNewInstance(mesh);
  skinMeshList.push_back(&logicalSliceExtractK->extractLogicalSlice(MiMesh::DIMENSION_K, 80, false, new MyCellFilter));

  double t2 = localTime.getElapsed();

  cout << "Time to extract logical slice:" << t2-t1 << endl;

  //viewMesh(mesh,  skinMeshList);

  MiMeshViz::finish();
  SoDB::finish();

  return 0;
}


//-----------------------------------------------------------------------------
//void viewMesh(const MiVolumeMeshRegular& volmesh, std::vector<const MiSurfaceMeshRegular* >& meshList) 
//{
//  // Init viewer
//  Widget my_window = SoXt::init(NAMESTR) ;
//  if (my_window == NULL) exit(1) ;
//
//  MeshSceneGraph meshSg(volmesh,meshList);
//
//  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
//  viewer->setSceneGraph(meshSg.getRoot());
//  viewer->show();
//  viewer->viewAll();
//
//  // dialog
//  SoXt::show(my_window);
//  SoXt::mainLoop();
//}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif
