#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>

#include "Mesh2DSceneGraph.h"

#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoIndexedFaceSet.h>

Mesh2DSceneGraph::Mesh2DSceneGraph(std::vector<const MiSurfaceMeshUnstructured* >& skinMeshList) : m_skinMeshList(skinMeshList) 
{ 
  std::vector<const MiSurfaceMeshUnstructured* >::const_iterator it;
  m_root = new SoSeparator;
  for (it = m_skinMeshList.begin(); it != m_skinMeshList.end() ; ++it)
  {
    m_root->addChild(buildMesh2DSceneGraph(*it));
  }
}

//-----------------------------------------------------------------------------
SoSeparator*  
Mesh2DSceneGraph::buildMesh2DSceneGraph(const MiSurfaceMeshUnstructured* mesh)
{
  SoSeparator* root = new SoSeparator;
  insertCoordinates(root,mesh);
  insertIndices(root,mesh);
  return root;
}

//-----------------------------------------------------------------------------
void
Mesh2DSceneGraph::insertCoordinates(SoSeparator* root,const MiSurfaceMeshUnstructured* mesh)
{
  const MiGeometryI& Mesh2DCoords = mesh->getGeometry();

  size_t numCoords = mesh->getTopology().getEndNodeId();
  if (numCoords==0)
    return;

  SoCoordinate3* ivcoord = new SoCoordinate3();

  ivcoord->point.setNum((int)numCoords);

  SbVec3f* coord = ivcoord->point.startEditing();
  for (size_t i=0; i<numCoords; ++i)
    *coord++ = SbVec3f(Mesh2DCoords.getCoord(i));
  ivcoord->point.finishEditing();

  root->addChild(ivcoord);
}

//-----------------------------------------------------------------------------
void
Mesh2DSceneGraph::insertIndices(SoSeparator* root,const MiSurfaceMeshUnstructured* mesh)
{
  const MiSurfaceTopologyExplicitI& Mesh2DCells = mesh->getTopology();
  size_t numCells = Mesh2DCells.getNumCells();
  if (numCells==0)
    return;

  SoIndexedFaceSet* faceSet = new SoIndexedFaceSet;

  std::vector<int> inds;
  inds.reserve(numCells*5); // we assume we have about 4 nodes per cell 

  for (size_t i=0; i<numCells; ++i)
  {
    const MiSurfaceCell* cell = Mesh2DCells.getCell(i);
    for (size_t j=0; j<cell->getNumNodes(); ++j)
      inds.push_back((int)cell->getNodeIndex(j));
    inds.push_back(-1);
  }

  faceSet->coordIndex.setValues(0,(int)inds.size(),&inds[0]);
  root->addChild(faceSet);
}


