#ifndef _MESHSCENEGRAPH_H
#define _MESHSCENEGRAPH_H

#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>

#include <Inventor/STL/vector>
class SoSeparator;

class MeshSceneGraph
{
public:
  MeshSceneGraph(const MiVolumeMeshRegular& volmesh, std::vector<const MiSurfaceMeshUnstructured* >& skinMeshList) 
    : m_volmesh(volmesh), 
    m_skinMeshList(skinMeshList)
  { 
    m_root = buildSceneGraph(); 
  }

  SoSeparator* getRoot() const {return m_root; }

protected:
  SoSeparator* buildSceneGraph();

  SoSeparator *m_root;
  const MiVolumeMeshRegular& m_volmesh;
  std::vector<const MiSurfaceMeshUnstructured* >& m_skinMeshList;
};

#endif


