#include "../Isosurf/Bench_Isosurf.h"
#include "../PlaneSlice/Bench_PlaneSlice.h"
#include "../Skin/Bench_Skin.h"

#include <MeshVizXLM/tessellator/MiTessellator.h>

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  BenchSkinParameters params;
  // Select Filters
  params.addFilter<NoCellFilterIjk>();
  params.addFilter<HalfCellFilterIjk>();
  params.addFilter<BorderCellFilterIjk>();
  params.addFilter<SliceICellFilterIjk>();
  params.addFilter<SliceKCellFilterIjk>();
  params.addFilter<CrossCellFilterIjk>();
  params.addFilter<SpreadHalfCellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 6;
  params.includeSequential = false;
  params.includeParallel = true;
  params.includeTouchMesh = true;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;

  int numDim = 5;
  size_t dims[] = { 100, 144, 220, 370, 470 };

  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK, HEXAHEDRON, TETRAHEDRON

  // =========== bench Isosurf ===========
  //Bench_Isosurf<meshT>:setNumThreads(4);
  {
    std::vector<Bench_Isosurf<REGULAR>::ScalarFctor*> scalarFctorList;
    scalarFctorList.push_back(new MbXFctor<double>);
    scalarFctorList.push_back(new MbSphereFctor<double>);
    Bench_Isosurf<REGULAR> bench(scalarFctorList,argc,argv);
    bench.run(dims,numDim,params);
    for (size_t i=0; i < scalarFctorList.size(); ++i)
      delete scalarFctorList[i];
  }
  
  {
    std::vector<Bench_Isosurf<HEXAHEDRON>::ScalarFctor*> scalarFctorList;
    scalarFctorList.push_back(new MbXFctor<double>);
    scalarFctorList.push_back(new MbSphereFctor<double>);
    Bench_Isosurf<HEXAHEDRON> bench(scalarFctorList,argc,argv);
    bench.run(dims,numDim,params);
    for (size_t i=0; i < scalarFctorList.size(); ++i)
      delete scalarFctorList[i];
  }

  {
    std::vector<Bench_Isosurf<HEXAHEDRONIJK>::ScalarFctor*> scalarFctorList;
    scalarFctorList.push_back(new MbXFctor<double>);
    scalarFctorList.push_back(new MbSphereFctor<double>);
    Bench_Isosurf<HEXAHEDRONIJK> bench(scalarFctorList,argc,argv);
    bench.run(dims,numDim,params);
    for (size_t i=0; i < scalarFctorList.size(); ++i)
      delete scalarFctorList[i];
  }

  // =========== bench Plane Slice ===========
  //Bench_PlaneSlice<meshT>:setNumThreads(4);
  {
    Bench_PlaneSlice<REGULAR> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  {
    Bench_PlaneSlice<HEXAHEDRON> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  {
    Bench_PlaneSlice<HEXAHEDRONIJK> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  // =========== bench Skin ===========
  //Bench_Skin<meshT>:setNumThreads(4);
  size_t subRanges[] = {0,50,65,90,100}; // list of relative cell range size comparing to the whole grid in percentage (only for IJK mesh)
  params.subRanges.assign(subRanges,subRanges+5);

  // additionnal params for skin bench
  params.forceBuildSkin = false;  
  params.fullExtractionAtFirst = false;  // do not apply cellfilter or cellrange if any for the first iteration of extraction

  {
    Bench_Skin<REGULAR,MiMeshIjk::LAYOUT_KJI> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  {
    Bench_Skin<HEXAHEDRON,MiMeshIjk::LAYOUT_KJI> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  {
    Bench_Skin<HEXAHEDRONIJK,MiMeshIjk::LAYOUT_KJI> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  {
    Bench_Skin<VERTEXHEXAHEDRONIJK,MiMeshIjk::LAYOUT_KJI> bench(argc,argv);
    bench.run(dims,numDim,params);
  }

  // Bench skin with no touch mesh (fill FCC only the first time)
  params.includeTouchMesh = false;
  // additionnal params for skin bench
  params.forceBuildSkin = true;
  params.fullExtractionAtFirst = false;  // do not apply cellfilter or cellrange if any for the first iteration of extraction
  {
    Bench_Skin<HEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
    bench.run(dims, numDim, params);
  }

  {
    Bench_Skin<VERTEXHEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
    bench.run(dims, numDim, params);
  }

  // Bench skin with full extraction first (build entire FCC first)
  params.fullExtractionAtFirst = true;  // do not apply cellfilter or cellrange if any for the first iteration of extraction
  {
      Bench_Skin<HEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
      bench.run(dims, numDim, params);
  }

  {
    Bench_Skin<VERTEXHEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
    bench.run(dims, numDim, params);
  }

  // Bench skin with no FCC
  SoPreferences::setBool("MESHVIZ_FACE_CONNECTIVITY_CACHES", 0);
  params.includeTouchMesh = true;
  params.forceBuildSkin = false;
  params.fullExtractionAtFirst = false;  // do not apply cellfilter or cellrange if any for the first iteration of extraction
  {
    Bench_Skin<HEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
    bench.run(dims, numDim, params);
  }

  {
    Bench_Skin<VERTEXHEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> bench(argc, argv);
    bench.run(dims, numDim, params);
  }

  return 0;
}


