#include "Bench_Mesh.h"
#include "BenchOutlineParameters.h"
#include "ExtractorTraits.h"

#include <MeshVizXLM/extractors/MiOutlineExtractIjk.h>
#include <MeshVizXLM/extractors/MiOutlineExtractHexahedronIjk.h>
#include <MeshVizXLM/extractors/MiOutlineExtractUnstructured.h>

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_UNKNOWN>
class Bench_Outline : public Bench_Mesh< typename ExtractorTraits<_MeshT>::OutlineExtractT, _MeshT, _Layout>
{
  typedef typename ExtractorTraits<_MeshT>::OutlineExtractT _ExtractT;

public:
  Bench_Outline( int argc, char* argv[] );
  void run( size_t* dims, size_t num, BenchOutlineParameters& params );

private:
  bool m_fullExtractionAtFirst;  // do not apply cellfilter or cellranges if any for the first iteration of extraction

  virtual void extract( _ExtractT* extractor, const typename Bench_Mesh<_ExtractT, _MeshT, _Layout>::FilterType* cellFilter ) const;
  virtual void writeCaseInfo( std::ostringstream& result ) const;

};

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
Bench_Outline<_MeshT, _Layout>::Bench_Outline( int argc, char* argv[] ) :
  Bench_Mesh<_ExtractT, _MeshT, _Layout>( "Outline", argc, argv )
  , m_fullExtractionAtFirst( false )
{
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Outline<_MeshT, _Layout>::writeCaseInfo( std::ostringstream &results ) const
{
  results << this->m_sep << std::setw( 8 ) << "100%";
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Outline<_MeshT, _Layout>::run( size_t* dims, size_t num, BenchOutlineParameters& params )
{
  m_fullExtractionAtFirst = params.fullExtractionAtFirst;
  Bench_Mesh<_ExtractT, _MeshT, _Layout>::run( dims, num, params );
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Outline<_MeshT, _Layout>::extract( _ExtractT* extractor, const typename Bench_Mesh<_ExtractT, _MeshT, _Layout>::FilterType* cellFilter ) const
{
  bool firstExtract = extractor->getExtract().getTopology().getNumCells() == 0;
  cellFilter = (m_fullExtractionAtFirst && firstExtract) ? NULL : cellFilter;
  extractor->extractOutline( cellFilter );
}
