#include "Bench_Outline.h"

//-----------------------------------------------------------------------------
int
main( int argc, char* argv[] )
{
  typedef Bench_Outline<HEXAHEDRONIJK, MiMeshIjk::LAYOUT_KJI> BenchOutline;
  // reduce number of threads
  //BenchOutline::setNumThreads(4);

  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK, VERTEXHEXAHEDRONIJK, HEXAHEDRON, HEXAHEDRON27, TETRAHEDRON
  // storage layout is effective only on  HEXAHEDRONIJK and VERTEXHEXAHEDRONIJK
  BenchOutline bench( argc, argv );

  BenchOutlineParameters params;
  // Select Filters
  //params.addFilter<NoCellFilterIjk>();
  //params.addFilter<ThirdCellFilterIjk>();
  params.addFilter<HalfCellFilterIjk>();
  //params.addFilter<BorderCellFilterIjk>();
  //params.addFilter<SliceICellFilterIjk>();
  //params.addFilter<SliceKCellFilterIjk>();
  //params.addFilter<CrossCellFilterIjk>();
  //params.addFilter<SpreadHalfCellFilterIjk>();
  //params.addFilter<Every2CellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 4;
  params.includeSequential = true;
  params.includeParallel = true;
  params.includeTouchMesh = false;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;
  params.includeSecondExtractor = true; // profiling with 2 instances of extractor

  params.fullExtractionAtFirst = false;  // do not apply cellfilter or cellrange if any for the first iteration of extraction

  size_t dims[] = { 100, 144, 220, 370, 470 };

  bench.run( dims, 5, params );

  return 0;
}


