#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>

#include <MeshVizXLM/extractors/MiSkinExtractUnstructured.h>
#include <MeshVizXLM/extractors/MiNonOverlappedCellsExtractUnstructured.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a tesselated line mesh from a quadratic mesh"

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//-----------------------------------------------------------------------------
int
main(int, char **)
{

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  std::vector<const MiSurfaceMeshUnstructured*> skinList;
  std::vector<MbVolumeMeshHexahedron<>*> meshList;
  std::vector<const MiScalardSetI*> scalarList;
  MbVec3d rotationCenter(0);
  MbSampleMeshBuilder<> meshBuilder1;
  meshList.push_back(&meshBuilder1.getMeshHexahedron(MbVec3<size_t>(3),MbVec3d(0),MbVec3d(3)));
  meshList.back()->getGeometry().rotate(1.0,0,&rotationCenter);
  MbSampleMeshBuilder<> meshBuilder2;
  meshList.push_back(&meshBuilder2.getMeshHexahedron(MbVec3<size_t>(3),MbVec3d(3,0.5,0.5),MbVec3d(6,3.5,3.5)));
  meshList.back()->getGeometry().rotate(1.0,0,&rotationCenter);

  MiSkinExtractUnstructured* skinExtract1 = MiSkinExtractUnstructured::getNewInstance(*meshList[0]);
  skinList.push_back(&skinExtract1->extractSkin());
  scalarList.push_back(&skinExtract1->extractScalarSet(*(meshList[0]->getScalarSet("$MyScalarSet"))));
  MiSkinExtractUnstructured* skinExtract2 = MiSkinExtractUnstructured::getNewInstance(*meshList[1]);
  skinList.push_back(&skinExtract2->extractSkin());
  scalarList.push_back(&skinExtract2->extractScalarSet(*(meshList[1]->getScalarSet("$MyScalarSet"))));
  MiNonOverlappedCellsExtractUnstructured* cellsExtract = MiNonOverlappedCellsExtractUnstructured::getNewInstance(skinList);
  const MeXSurfaceMeshUnstructured& nonOverlappingSurface = cellsExtract->extractSurface();
  const MeXScalardSetI& scalarSet = cellsExtract->extractScalarSet(scalarList);


  MoMesh* surfaceMesh = new MoMesh;
  surfaceMesh->setMesh(&nonOverlappingSurface); 

  MoScalarSetI* scalarSetNode = new MoScalarSetI;
  scalarSetNode->setScalarSet(&scalarSet);

  MoMaterial* material = new MoMaterial;

  MoDrawStyle* style = new MoDrawStyle;
  style->displayEdges = true;
  style->displayFaces = false;

  // Display the surface mesh
  MoMeshSurface *surface = new MoMeshSurface;

  //
  MoPredefinedColorMapping* colorMapping = new MoPredefinedColorMapping;
  colorMapping->predefColorMap = MoPredefinedColorMapping::STANDARD;
  colorMapping->minValue = float(scalarSet.getMin());
  colorMapping->maxValue = float(scalarSet.getMax());

  SoShapeHints* shapeHints = new SoShapeHints;
  shapeHints->creaseAngle = 1.0;
  shapeHints->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);


  SoSeparator* sep = new SoSeparator;
  sep->ref();
  {
    sep->addChild(material);
    sep->addChild(style);
    sep->addChild(shapeHints);
    sep->addChild(colorMapping);

    sep->addChild(scalarSetNode);

    sep->addChild(surfaceMesh);

    sep->addChild(surface);
  }

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  sep->unref();
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

