#include "Bench_Mesh.h"
#include <MeshVizXLM/extractors/MiPlaneSliceExtractIjk.h>
#include <MeshVizXLM/extractors/MiPlaneSliceExtractHexahedronIjk.h>
#include <MeshVizXLM/extractors/MiPlaneSliceExtractUnstructured.h>
#include "ExtractorTraits.h"

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class Bench_PlaneSlice : public Bench_Mesh< typename ExtractorTraits<_MeshT>::PlaneSliceExtractT,_MeshT,_Layout>
{
  typedef typename ExtractorTraits<_MeshT>::PlaneSliceExtractT _ExtractT;
public:
  Bench_PlaneSlice(int argc, char* argv[]);

private:
  virtual typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::MeshType*   getMesh(size_t num, bool deadCells);
  virtual void extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT>::FilterType* cellFilter) const;

  double        m_distance;
};

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
Bench_PlaneSlice<_MeshT,_Layout>::Bench_PlaneSlice(int argc, char* argv[]) : 
Bench_Mesh<_ExtractT,_MeshT,_Layout>("Planeslice",argc,argv)
{
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
typename Bench_Mesh<typename ExtractorTraits<_MeshT>::PlaneSliceExtractT,_MeshT,_Layout>::MeshType*
Bench_PlaneSlice<_MeshT,_Layout>::getMesh(size_t num, bool deadCells)
{
  typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::MeshType* mesh = Bench_Mesh<_ExtractT,_MeshT,_Layout>::getMesh(num,deadCells);
  m_distance = mesh->getGeometry().getMin()[0] + (( mesh->getGeometry().getMax()[0] - mesh->getGeometry().getMin()[0] ) / 3.0);
  return mesh;
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_PlaneSlice<_MeshT,_Layout>::extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT>::FilterType* cellFilter) const
{
  extractor->extractSlice(MbVec3d(1,0,0),m_distance,cellFilter);
}
