#include "Bench_PlaneSlice.h"

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  // reduce number of threads
  //Bench_PlaneSlice<meshT>::setNumThreads(4);

  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK, HEXAHEDRON, TETRAHEDRON
  // storage layout is effective on all types of meshes except unstructured ones
  Bench_PlaneSlice<HEXAHEDRON,MiMeshIjk::LAYOUT_KJI> bench(argc,argv);

  BenchParameters params;
  // Select Filters
  params.addFilter<NoCellFilterIjk>();
  params.addFilter<HalfCellFilterIjk>();
  params.addFilter<BorderCellFilterIjk>();
  params.addFilter<SliceICellFilterIjk>();
  //params.addFilter<SliceKCellFilterIjk>();
  //params.addFilter<CrossCellFilterIjk>();
  //params.addFilter<SpreadHalfCellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 4;
  params.includeSequential = true;
  params.includeParallel = true;
  params.includeTouchMesh = true;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;

  size_t dims[5] = { 100, 144, 220, 370, 470 };
  bench.run(dims,5,params);

  return 0;
}


