#include <fstream>
#include <iostream>
#include <iomanip>
#include <Inventor/SoPreferences.h> 
#include <MeshVizXLM/MiMeshViz.h>
#include <MeshVizXLM/extractors/MiPointProbeIjk.h>

#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>

#include <MbSampleMeshBuilder.h>

#include <Inventor/SbElapsedTime.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM regular volume pointprobe extraction bench"

void run(vector<size_t>& dims, ostringstream& results, const char* sep = " ");
double probeMesh(size_t dim, const MbVec3d& minBB, const MbVec3d& maxBB, double rotation, ostringstream& result, const char* sep = " ");

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

SbElapsedTime localTime;

MbSampleMeshBuilder<MbVec3d, double> meshBuilder;

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  ostream* output = &cout;
  const char* sep = "";

  if(argc>1)
  {
    if (strcmp(argv[1],"-f")==0)
    {
      const char* filename = "bench_pointprobe.csv";
      if (argc == 3)
         filename = argv[2];
      output = new ofstream(filename);
      sep = ";";
    }
    else
    {
      cout << "bench [-f [filename] ]: print result in file .csv" << endl;
      exit(1);
    }
  }

  MiMeshViz::init();

  ostringstream results;
  results << setw(10) << "MeshType" << sep  << setw(10) << "NumCells" << sep << setw(15) << "ProbedPoints" << sep ;
  results << setw(14) << "InitTime(sec)";
  results << sep << setw(18) << "OverallTime(sec)" << sep <<setw(25) << "Time for 10000 pts(sec)" << endl;

  results.precision(4);
  results.setf ( ios::showbase );

      //run bench for regulr mesh
  size_t dims[5] = { 100, 144, 220, 370, 470 };
  vector<size_t> dimensions(dims, dims + 5);
  run(dimensions,results,sep);

  (*output) << results.str();

  if (argc>1)
    delete output;

  MiMeshViz::finish();
  return 0;
}

void run(vector<size_t>& dims, ostringstream& results, const char* sep)
{
  for (size_t d = 0; d < dims.size(); d++)
  {
    probeMesh(dims[d],MbVec3d(0),MbVec3d(100),0.0,results, sep);
    cout << endl;
  }
}

double
probeMesh(size_t dim, const MbVec3d& minBB, const MbVec3d& maxBB, double rotation, ostringstream& result, const char* sep)
{
  const MiVolumeMeshRegular& mesh = meshBuilder.getVolumeMeshRegular(MbVec3<size_t>(dim), minBB, maxBB);
  
  MbVec3d startP = minBB;
  size_t numExtract = dim*dim*dim;
  MbVec3d delta = (maxBB-minBB)/double(dim);
  MbVec3d u(delta[0],0,0), v(0,delta[1],0), w(0,0,delta[3]);
  if(rotation>0.0)
  {
    double cosa = cos(rotation);
    double sina = sin(rotation);
    u[0] = delta[0]*cosa;
    u[1] = delta[0]*sina;
    v[0] = - delta[1]*sina;
    v[1] = delta[1]*cosa;
    delta[0] = u[0] + v[0];
    delta[1] = u[1] + v[1];
  }
  MbVec3d point, spoint;
  point = spoint = startP + delta*0.5;

  double tb = localTime.getElapsed();
  // Get an instance of a probe according to the mesh type
  MiPointProbeIjk* probe = MiPointProbeIjk::getNewInstance(mesh);
  double tc = localTime.getElapsed();

  // first probe not benched to ignore initial memory alloc
  probe->setLocation(point);
  
  double t1 = localTime.getElapsed();

  cout << "start probing " << numExtract << " points" << endl;
  for (size_t i=0; i<dim; ++i)
  {
    for (size_t j=0; j<dim; ++j)
    {
      for (size_t k=0; k<dim; ++k)
      {
        probe->setLocation(point);
        point[2] +=  delta[2];
      }
      point.setValue(point[0]+v[0],point[1]+v[1],spoint[2]);
    }
    spoint += u;
    point = spoint;
  }

  double t2 = localTime.getElapsed();

  result << setw(10) << "Regular" << sep << setw(10) << numExtract << sep << setw(15) << numExtract << sep;
  result << setw(14) << tc-tb;
  result << sep << setw(18) << t2-t1 << sep  <<setw(25) << 10000*(t2-t1)/float(numExtract) << endl;

  delete probe;
  return t2-t1;
  }

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif
