#ifndef  _BenchSkinParameters_h
#define  _BenchSkinParameters_h

#include "BenchParameters.h"

class MiTessellator;

class BenchSkinParameters : public BenchParameters
{
public:
  BenchSkinParameters();

  bool forceBuildSkin; // force rebuilding the skin on a second extraction even if the mesh remains untouched
  std::vector<size_t> subRanges; // list of relative cell range size comparing to the whole grid in percentage
  bool fullExtractionAtFirst;  // do not apply cellfilter or cellranges if any for the first iteration of extraction
  bool extractLineSkin; // include line skin extraction (only for hexahedron27 mesh)
};


BenchSkinParameters::BenchSkinParameters() :
forceBuildSkin(false), subRanges(1, 100), fullExtractionAtFirst(false), extractLineSkin(false)
{
}


#endif 


