#include "Bench_Mesh.h"
#include <MeshVizXLM/extractors/MiSkinExtractIjk.h>
#include <MeshVizXLM/extractors/MiSkinExtractHexahedronIjk.h>
#include <MeshVizXLM/extractors/MiSkinExtractUnstructured.h>
#include "ExtractorTraits.h"
#include "BenchSkinParameters.h"

template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_UNKNOWN>
class Bench_Skin : public Bench_Mesh< typename ExtractorTraits<_MeshT>::SkinExtractT,_MeshT, _Layout>
{
  typedef typename ExtractorTraits<_MeshT>::SkinExtractT _ExtractT;

  struct Tuple : public MbVec3ui
  {
    Tuple(size_t t = 0) : MbVec3ui(t,UNDEFINED_ID,UNDEFINED_ID) {}
    operator size_t() const {return (*this)[0]; }
  };

public:
  typedef std::pair<Tuple,Tuple> CellRange;

  Bench_Skin(int argc, char* argv[]);
  void run(size_t* dims, size_t num, BenchSkinParameters& params);

private:
  bool m_forceBuildSkin; // force rebuilding the skin on a second extraction even if the mesh remains untouched
  std::vector<size_t> m_subRanges; // list of relative cell range size comparing to the whole grid in percentage
  bool m_fullExtractionAtFirst;  // do not apply cellfilter or cellranges if any for the first iteration of extraction
  bool m_extractLineSkin; // include line skin extraction (only for hexahedron27 mesh)

  virtual void runCase(size_t caseNum);
  virtual void extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::FilterType* cellFilter) const;
  virtual void writeCaseInfo(std::ostringstream& result) const;

  CellRange m_currentCellRange;
  size_t    m_currentSubRangeRatio;

  void extractLineSkin(MiSkinExtractIjk* /*extractor*/, const MiCellFilterIjk* /*cellFilter*/) const
  {
  }

  void extractLineSkin(MiSkinExtractUnstructured* extractor, const MiCellFilterI* cellFilter) const
  {
      extractor->extractLineSkin(cellFilter);
  }

};

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
Bench_Skin<_MeshT,_Layout>::Bench_Skin(int argc, char* argv[]) : 
Bench_Mesh<_ExtractT,_MeshT,_Layout>("Skin",argc,argv), m_forceBuildSkin(false), m_subRanges(1,100), m_fullExtractionAtFirst(false),
m_extractLineSkin(false), m_currentCellRange(UNDEFINED_ID, UNDEFINED_ID)
{
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Skin<_MeshT, _Layout>::writeCaseInfo(std::ostringstream &results) const
{
  results << this->m_sep << std::setw(8) << m_currentSubRangeRatio << "%";
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Skin<_MeshT,_Layout>::run(size_t* dims, size_t num, BenchSkinParameters& params)
{
  m_forceBuildSkin = params.forceBuildSkin;
  m_fullExtractionAtFirst = params.fullExtractionAtFirst;
  m_subRanges = params.subRanges;
  m_extractLineSkin = params.extractLineSkin;
  Bench_Mesh<_ExtractT,_MeshT,_Layout>::run(dims,num,params);
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Skin<_MeshT,_Layout>::runCase(size_t caseNum)
{
  for (size_t s = 0; s < m_subRanges.size(); ++s)
  {
    m_currentSubRangeRatio = m_subRanges[s];
    if (m_currentSubRangeRatio < 100)
    {
      size_t offset = (size_t)((this->m_dims[caseNum] * (100 - m_currentSubRangeRatio)) / 200.0);
      m_currentCellRange.first = offset;
      m_currentCellRange.second = this->m_dims[caseNum] - offset;
      if (m_currentCellRange.first == m_currentCellRange.second)
        m_currentCellRange.second[0] += 1;
      std::cout << m_currentSubRangeRatio << "% sub range extraction [" << m_currentCellRange.first[0] << " " << m_currentCellRange.second[0] << "]" << std::endl;
    }
    else
      m_currentCellRange = CellRange(UNDEFINED_ID,UNDEFINED_ID);
    Bench_Mesh<_ExtractT,_MeshT,_Layout>::runCase(caseNum);
  }
}

//-----------------------------------------------------------------------------
template <MeshImpl _MeshT, MiMeshIjk::StorageLayout _Layout>
void
Bench_Skin<_MeshT,_Layout>::extract(_ExtractT* extractor, const typename Bench_Mesh<_ExtractT,_MeshT,_Layout>::FilterType* cellFilter) const
{
  bool firstExtract = extractor->getExtract().getTopology().getNumCells() == 0;
  if (m_forceBuildSkin)
      extractor->clearCellRanges();
  if (!(firstExtract && m_fullExtractionAtFirst))
    extractor->addCellRange(m_currentCellRange.first,m_currentCellRange.second);
  cellFilter = (m_fullExtractionAtFirst && firstExtract) ? NULL : cellFilter;
  extractor->extractSkin(cellFilter);
  if (m_extractLineSkin)
    extractLineSkin(extractor, cellFilter);
}
