#include "Bench_Skin.h"
#include <MeshVizXLM/tessellator/MiTessellator.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>

//-----------------------------------------------------------------------------
int
main(int argc, char* argv[])
{
  typedef Bench_Skin<HEXAHEDRON, MiMeshIjk::LAYOUT_KJI> BenchSkin;
  // reduce number of threads
  //BenchSkin::setNumThreads(4);

  // Select Mesh Type:
  // REGULAR, RECTILINEAR, CURVILINEAR, HEXAHEDRONIJK, VERTEXHEXAHEDRONIJK, HEXAHEDRON, HEXAHEDRON27, TETRAHEDRON
  // storage layout is effective only on  HEXAHEDRONIJK and VERTEXHEXAHEDRONIJK
  BenchSkin bench(argc, argv);

  BenchSkinParameters params;
  // Select Filters
  params.addFilter<NoCellFilterIjk>();
  params.addFilter<ThirdCellFilterIjk>();
  params.addFilter<HalfCellFilterIjk>();
  //params.addFilter<BorderCellFilterIjk>();
  params.addFilter<SliceICellFilterIjk>();
  //params.addFilter<SliceKCellFilterIjk>();
  //params.addFilter<CrossCellFilterIjk>();
  //params.addFilter<SpreadHalfCellFilterIjk>();
  //params.addFilter<Every2CellFilterIjk>();

  // Select Options
  params.includeProgressCallback = false;
  params.displayPhaseTimings = false;
  params.numIteration = 4;
  params.includeSequential = true;
  params.includeParallel = true;
  params.includeTouchMesh = true;
  params.includeOnlyFiltering = false;
  params.includeDeadCells = false;
  params.includeMicroSleep = false;

  MxEdgeErrorMetricGeometry metric(0.1);
  //params.tessellator = MiTessellator::getNewTessellatorGeometry(metric); 

  params.forceBuildSkin = false;       // force rebuilding the skin on a second extraction even if the mesh remains untouched
  //params.subRanges.assign(subRanges,subRanges+sizeof(subRanges) / sizeof(size_t));
  params.fullExtractionAtFirst = false;  // do not apply cellfilter or cellrange if any for the first iteration of extraction
  params.extractLineSkin = false; // include line skin extraction (only for hexahedron27 mesh)

  size_t dims[] = { 100, 144, 220, 370, 470 };

  bench.run(dims,5,params);

  //delete params.tessellator;

  return 0;
}


