#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshLine.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>

#include <MeshVizXLM/extractors/MiTessellatedLineExtract.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricScalar.h>

#include <mesh/lines/QuadraticLineMesh.h>


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoMarkerSet.h>


#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a tesselated line mesh from a quadratic mesh"

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//-----------------------------------------------------------------------------
int
main(int, char **)
{

 QuadraticLineMesh quadraticMesh;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();


  // Build a sample surface mesh
  
  // ======== linear representation of the quadratic line (use a basic tesselator) ==========
  MiTessellator* basicTessellator = MiTessellator::getNewTessellatorBasic();
  MiTessellatedLineExtract* basicExtract = MiTessellatedLineExtract::getNewInstance(quadraticMesh);
  const MeXLineMeshUnstructured& basicMesh = basicExtract->tessellate(*basicTessellator);

  MoMesh* basicMeshNode = new MoMesh;
  basicMeshNode->setMesh(&basicMesh); 

  SoMaterial* basicMaterial = new SoMaterial;
  basicMaterial->diffuseColor = SbColor(1,0,0);

  // ======== tessellated representation of the quadratic line (use a fine tesselator) ==========
#define USE_TESS_GEOMETRY
  //#define USE_TESS_SCALAR
#ifdef USE_TESS_GEOMETRY
  MxEdgeErrorMetricGeometry edgeErrorMetricGeometry(0.02);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(edgeErrorMetricGeometry);
  //MxTessellatorGeometry tessellator(quadraticMesh.getTopology(),quadraticMesh.getGeometry(),edgeErrorMetricGeometry);
#elif USE_TESS_SCALAR
  QuadraticScalardSetI quadDataSet;
  MxEdgeErrorMetricScalar edgeErrorMetricScalar(0.05);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorScalar(edgeErrorMetricScalar);
#else
  QuadraticScalardSetI quadDataSet;
  MxEdgeErrorMetricScalar edgeErrorMetricScalar(0.05);
  MxEdgeErrorMetricGeometry edgeErrorMetricGeometry(0.04);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometryAndScalar(edgeErrorMetricGeometry,edgeErrorMetricScalar);
#endif

  // Extract the tessellated line mesh
  MiTessellatedLineExtract* tessellatorExtract = MiTessellatedLineExtract::getNewInstance(quadraticMesh);
  const MeXLineMeshUnstructured& tessellatedMesh = tessellatorExtract->tessellate(*tessellator);

  MoMesh* tessellatedMeshNode = new MoMesh;
  tessellatedMeshNode->setMesh(&tessellatedMesh); //MiLineMeshUnstructured

  SoMaterial* tessellatedMaterial = new SoMaterial;
  tessellatedMaterial->diffuseColor = SbColor(1,1,1);


  //// Color map
  //MoPredefinedColorMapping* colorMap = new MoPredefinedColorMapping;
  //colorMap->minValue = (float)mesh.getScalarSet(1)->getMin();
  //colorMap->maxValue = (float)mesh.getScalarSet(1)->getMax();
  //colorMap->predefColorMap = MoPredefinedColorMapping::STANDARD;

  SoMaterial* meshNodesMaterial = new SoMaterial;
  meshNodesMaterial->diffuseColor = SbColor(1,0,1);

  const std::vector<MbVec3d> coords = quadraticMesh.getCoords();
  SoCoordinate3* meshCoords = new SoCoordinate3;
  meshCoords->point.setValues(0,(int)coords.size(),(const SbVec3d*)&coords[0]);

  SoMarkerSet* meshNodes = new SoMarkerSet;
  meshNodes->markerIndex.setValue(SoMarkerSet::STAR_9_9); // SATELLITE_LINE_9_9


  // Display the line mesh
  MoMeshLine *line1 = new MoMeshLine;
  MoMeshLine *line2 = new MoMeshLine;

  SoSeparator* sep = new SoSeparator;
  sep->ref();
  {
    //sep->addChild(colorMap);
    sep->addChild(basicMaterial);
    sep->addChild(basicMeshNode);
    sep->addChild(line1);

    sep->addChild(meshNodesMaterial);
    sep->addChild(meshCoords);
    sep->addChild(meshNodes);

    sep->addChild(tessellatedMaterial);
    sep->addChild(tessellatedMeshNode);
    sep->addChild(line2);
  }

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  sep->unref();
  MoMeshViz::finish();
  SoXt::finish();


  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

