#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/manips/SoClipPlaneManip.h>

#include <MeshVizXLM/extractors/MiPolyhedralToMixVolumeExtract.h>

#include <PolyhedralMeshReader.h>
#include <PEBIReader.h>
#include <mesh/volumes/PEBIMesh.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>

#include <Inventor/helpers/SbFileHelper.h>

using namespace std;

#define NAMESTR "MeshVizXLM Sample program"

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

SoSwitch* m_cellSwitch;
MoMeshCellShape *m_cellShape;
PolyhedralMeshReader m_reader;
PEBIReader m_PEBIReader;
SoXtExaminerViewer* viewer;

SbString DataPath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshVizXLM/");
static std::string s_demoPath = DataPath.toStdString() ;

static MiPolyhedralToMixVolumeExtract* extract;
static const MiVolumeMeshUnstructured*  mesh;
static const MbScalardSetI* scalarSet;

class UserData 
{
public:
  UserData(MoMesh *moMesh, MoScalarSetI *moScalarSetI, MoPredefinedColorMapping* colMap) :
      m_moMesh(moMesh), m_moScalarSetI(moScalarSetI), m_colMap(colMap) {}
    
  MoMesh * getMoMesh() { return m_moMesh; }
  MoScalarSetI *getMoScalarSetI() { return m_moScalarSetI;}
  MoPredefinedColorMapping* getColorMap() { return m_colMap; }

private:
  MoMesh *m_moMesh;
  MoScalarSetI *m_moScalarSetI;
  MoPredefinedColorMapping* m_colMap;
};

void
editCellShape(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshCellShape *cell = (MoMeshCellShape*) (userData);
  if (cell) {
    if (SO_KEY_PRESS_EVENT(ev, U)) 
    {
      float factor = cell->factor.getValue();
      cell->factor.setValue(factor + (float)0.01);
      handled = true;
    } 
    if (SO_KEY_PRESS_EVENT(ev, D)) 
    {
      float factor = cell->factor.getValue();
      cell->factor.setValue(factor - (float)0.01);
      handled = true;
    }
    if (SO_KEY_PRESS_EVENT(ev, C)) 
    {
      m_cellSwitch->whichChild = ( m_cellSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
  }
  if (handled)
    eventCB->setHandled();
}

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  const MiVolumeMeshUnstructured* nmesh = nullptr;
  const MiScalardSetI* ndata = nullptr;
  const MbVolumeMeshUnstructured<>* origMesh;

  bool handled = false;
  bool newmesh = false;

  UserData* myUserData = (UserData*) (userData);
  MoMesh *moMesh = myUserData->getMoMesh();
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, F1))
    {
      cout << "Displaying single polyhedron" << endl;
      nmesh = mesh = origMesh = &m_reader.readMesh(s_demoPath + "polyhedron.dat");
      ndata = scalarSet = origMesh->getScalarSet(0); 
      delete extract;
      extract = NULL;
      newmesh = handled = true;
    }
    if (SO_KEY_PRESS_EVENT(ev, F2))
    {
      cout << "Displaying single hexagon" << endl;
      nmesh = mesh = origMesh = &m_reader.readMesh(s_demoPath + "FE3DHexagon.dat");
      ndata = scalarSet = origMesh->getScalarSet(0); 
      delete extract;
      extract = NULL;
      newmesh= handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F3))
    {
      cout << "Displaying cone" << endl;
      nmesh = mesh = origMesh =&m_reader.readMesh(s_demoPath + "cone.dat");
      ndata = scalarSet = origMesh->getScalarSet(0); 
      delete extract;
      extract = NULL;
      newmesh = handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F4))
    {
      cout << "Displaying sphere" << endl;
      nmesh = mesh = origMesh = &m_reader.readMesh(s_demoPath + "sphere.dat");
      ndata = scalarSet = origMesh->getScalarSet(0); 
      delete extract;
      extract = NULL;
      newmesh = handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F5))
    {
      cout << "PEBI mesh" << endl;
      PEBIMesh* pmesh;
      nmesh = mesh = pmesh = &m_PEBIReader.generate3D(s_demoPath + "polySurf_100.txt");
      ndata = scalarSet = &pmesh->getScalarSet();
      delete extract;
      extract = NULL;
      newmesh = handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, T) )
    {
      if ( extract == NULL)
      {
        cout << "Tessellating mesh" << endl;
        extract = MiPolyhedralToMixVolumeExtract::getNewInstance(*mesh);
        nmesh = &extract->convert(); 
        if ( scalarSet )
          ndata = &extract->extractScalarSet(*scalarSet);
        else
          ndata = NULL;
        cout << "Done - Displaying tessellated mesh" << endl;
      }
      else
      {
        cout << "Displaying original mesh" << endl;
        delete extract;
        extract = NULL;
        nmesh = mesh;
        ndata = scalarSet;
      }  
      handled = true;
    }
  }

  if (handled)
  {
    moMesh->setMesh(nmesh);
    MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
    moScalarSetI->setScalarSet(ndata);
    if ( scalarSet )
    {
      myUserData->getColorMap()->minValue = (float)scalarSet->getMin();
      myUserData->getColorMap()->maxValue = (float)scalarSet->getMax();
    }
    eventCB->setHandled();
    if(newmesh) viewer->viewAll();
  }

}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press F1 for single polyhedron " << endl;
  cout << "Press F2 for single hexagon " << endl;
  cout << "Press F3 for cone" << endl;
  cout << "Press F4 for sphere" << endl;
  cout << "Press F5 for PEBI mesh" << endl;
  cout << "Press t to enable/disable tessellation" << endl;
  cout << "Press c to enable/disable cells visibility" << endl;
  cout << "Press u/d for scaling cells" << endl;

  const MbVolumeMeshUnstructured<>* origMesh = &m_reader.readMesh(s_demoPath + "cone.dat");
  mesh = origMesh;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  sep->ref();
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  extract = NULL;

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(mesh);
  sep->addChild(moMesh);

  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  sep->addChild(colMap);

  // Adjust range to scalar set 1
  scalarSet = origMesh->getScalarSet(0);
  
  // First Scalar Value
  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  sep->addChild(moScalarSetI);
  
  if ( scalarSet )
  {
    colMap->minValue = (float)scalarSet->getMin();
    colMap->maxValue = (float)scalarSet->getMax();
    colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
    moScalarSetI->setScalarSet(scalarSet);
  }

  m_cellSwitch = new SoSwitch;
  m_cellSwitch->whichChild = SO_SWITCH_ALL;
  sep->addChild(m_cellSwitch);

  // CellShape Section
  m_cellShape = new MoMeshCellShape;
  m_cellShape->inclusiveList = false;
  m_cellShape->factor.setValue(0.4f);
  m_cellShape->showCellName = FALSE;
  m_cellShape->showNodeName = FALSE;
  m_cellSwitch->addChild(m_cellShape);

  // Use Scalar set 1 to color the CellShape
  m_cellShape->colorScalarSetId = 0;

  SoEventCallback *myCallbackNode1 = new SoEventCallback;
  UserData userData(moMesh,moScalarSetI,colMap);
  myCallbackNode1->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, &userData); 
  sep->addChild(myCallbackNode1);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellShape, m_cellShape); 
  sep->addChild(myCallbackNode2);

  // Transparent Mesh Skin
  SoDrawStyle* style = new SoDrawStyle;
  style->style.setValue(SoDrawStyle::LINES);
  sep->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = 0;
  sep->addChild(skin);

  viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  sep->unref();
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

