#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>

#include <MeshVizXLM/extractors/MiTessellatedSurfaceExtract.h>

#include <MeshVizXLM/tessellator/MiTessellator.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricScalar.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoMarkerSet.h>

#include <mesh/surfaces/QuadraticSurfaceMesh.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a tesselated line mesh from a quadratic mesh"

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//-----------------------------------------------------------------------------
int
main(int, char **)
{

 QuadraticSurfaceMesh quadraticMesh;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();


  // Build a sample surface mesh
  
  ScalarSet inputScalarSet(quadraticMesh);

  //// ======== linear representation of the quadratic surface (use a basic tesselator) ==========
//#define DRAW_BASICMESH
#ifdef DRAW_BASICMESH
  MiTessellator* basicTessellator = MiTessellator::getNewTessellatorBasic(quadraticMesh.getTopology(),quadraticMesh.getGeometry());

  MiTessellatedSurfaceExtract* basicExtract = MiTessellatedSurfaceExtract::getNewInstance(quadraticMesh);
  const MeXSurfaceMeshUnstructured& basicMesh = basicExtract->tessellate(*basicTessellator);
  const MeXScalardSetI& sc = basicExtract->extractScalarSet(inputScalarSet);

  MoMesh* basicMeshNode = new MoMesh;
  basicMeshNode->setMesh(&basicMesh); 
  //basicMeshNode->setMesh(&quadraticMesh); 

  MoScalarSetI* basicScalarSetNode = new MoScalarSetI;
  basicScalarSetNode->setScalarSet(&sc);

#endif

  // ======== tessellated representation of the quadratic line (use a fine tesselator) ==========
#define DRAW_TESSELLATION
#ifdef DRAW_TESSELLATION
#define USE_TESS_GEOMETRY
//#define USE_TESS_SCALAR
#ifdef USE_TESS_GEOMETRY
  MxEdgeErrorMetricGeometry edgeErrorMetricGeometry(0.05);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(edgeErrorMetricGeometry);
#elif USE_TESS_SCALAR
  QuadraticScalardSetI quadDataSet;
  MxEdgeErrorMetricScalar edgeErrorMetricScalar(0.05);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorScalar(edgeErrorMetricScalar);
#else
  QuadraticScalardSetI quadDataSet;
  MxEdgeErrorMetricScalar edgeErrorMetricScalar(0.05);
  MxEdgeErrorMetricGeometry edgeErrorMetricGeometry(0.04);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometryAndScalar(edgeErrorMetricGeometry,edgeErrorMetricScalar);
#endif

  // Extract the tessellated line mesh
  MiTessellatedSurfaceExtract* tessellatorExtract = MiTessellatedSurfaceExtract::getNewInstance(quadraticMesh);
  const MeXSurfaceMeshUnstructured& tessellatedMesh = tessellatorExtract->tessellate(*tessellator);
  const MeXScalardSetI& sc = tessellatorExtract->extractScalarSet(inputScalarSet);

  MoMesh* tessellatedMeshNode = new MoMesh;
  tessellatedMeshNode->setMesh(&tessellatedMesh); 

  MoScalarSetI* tessellatedScalarSetNode = new MoScalarSetI;
  tessellatedScalarSetNode->setScalarSet(&sc);
#endif

  SoMaterial* basicMaterial = new SoMaterial;
  basicMaterial->diffuseColor = SbColor(0,0,1);

  SoMaterial* tessellatedMaterial = new SoMaterial;
  tessellatedMaterial->diffuseColor = SbColor(1,0,0);

  SoDrawStyle* drawStyle = new SoDrawStyle;
  drawStyle->style = SoDrawStyle::LINES;

  const std::vector<MbVec3d> coords = quadraticMesh.getCoords();
  SoCoordinate3* meshCoords = new SoCoordinate3;
  meshCoords->point.setValues(0,int(coords.size()),(const SbVec3d*)&coords[0]);

  SoMaterial* meshNodesMaterial = new SoMaterial;
  meshNodesMaterial->diffuseColor = SbColor(1,0,1);

  SoMarkerSet* meshNodes = new SoMarkerSet;
  meshNodes->markerIndex.setValue(SoMarkerSet::STAR_9_9); // SATELLITE_LINE_9_9

  // Display the surface mesh
  MoMeshSurface *surface = new MoMeshSurface;

  //
  MoPredefinedColorMapping* colorMapping = new MoPredefinedColorMapping;
  colorMapping->predefColorMap = MoPredefinedColorMapping::STANDARD;
  colorMapping->minValue = float(inputScalarSet.getMin());
  colorMapping->maxValue = float(inputScalarSet.getMax());

  SoShapeHints* shapeHints = new SoShapeHints;
  shapeHints->creaseAngle = 1.0;
  shapeHints->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);

  SoSeparator* sep = new SoSeparator;
  sep->ref();
  {
    //sep->addChild(colorMap);
    //sep->addChild(drawStyle);
    sep->addChild(shapeHints);
    sep->addChild(colorMapping);

#ifdef DRAW_BASICMESH
    sep->addChild(basicScalarSetNode);
    sep->addChild(basicMaterial);
    sep->addChild(basicMeshNode);
    sep->addChild(surface);
#endif

#ifdef DRAW_TESSELLATION
    sep->addChild(tessellatedScalarSetNode);
    sep->addChild(tessellatedMaterial);
    sep->addChild(tessellatedMeshNode);
    sep->addChild(surface);
#endif

    sep->addChild(meshNodesMaterial);
    sep->addChild(meshCoords);
    sep->addChild(meshNodes);
  }

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  sep->unref();
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif
