#include "Bench_TessellationPolyhedron.h"
#include "../../Common.h"

#include <Inventor/helpers/SbFileHelper.h>

Bench_TessellationPolyhedron::Bench_TessellationPolyhedron(const std::string& name, int argc, char* argv[]) : 
Bench<MiPolyhedralToMixVolumeExtract,PEBIMesh>(name,"VolumeMeshPolyhedron",argc,argv) 
{
  SbString DataPath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshVizXLM/");
  m_demoPath = DataPath.toStdString() ;
  m_filenames[0] = "polySurf_1000.txt";
  m_filenames[1] = "polySurf_10000.txt";
  m_filenames[2] = "polySurf_100000.txt";
}

PEBIMesh* 
Bench_TessellationPolyhedron::getMesh(size_t num, bool)
{
  return &m_reader.generate3D(m_demoPath + m_filenames[num]);
}

size_t
Bench_TessellationPolyhedron::getNumCells() const
{
  return m_currentMesh->getTopology().getNumCells();
}

void
Bench_TessellationPolyhedron::extract(MiPolyhedralToMixVolumeExtract* extractor, const CellFilter* cellFilter) const
{
  extractor->convert(cellFilter);
}


