#ifndef _Bench_TessellationPolyhedron_h
#define _Bench_TessellationPolyhedron_h

#include "Bench.h"

#include <MeshVizXLM/extractors/MiPolyhedralToMixVolumeExtract.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>

#include <mesh/volumes/PEBIMesh.h> 
#include <PEBIReader.h> 

#include <Inventor/STL/string>

template<>
inline MiPolyhedralToMixVolumeExtract*
Bench<MiPolyhedralToMixVolumeExtract,PEBIMesh>::getNewExtractor(PEBIMesh &mesh, bool parallel)
{
  return MiPolyhedralToMixVolumeExtract::getNewInstance(mesh,parallel);
}

class Bench_TessellationPolyhedron : public Bench<MiPolyhedralToMixVolumeExtract,PEBIMesh>
{
public:
  Bench_TessellationPolyhedron(const std::string& name, int argc, char* argv[]);
  ~Bench_TessellationPolyhedron() {}

private:
  virtual PEBIMesh* getMesh(size_t num, bool deadCells);
  virtual size_t    getNumCells() const;
  virtual void      extract(MiPolyhedralToMixVolumeExtract* extractor, const CellFilter* cellFilter) const;

  mutable PEBIReader m_reader;
  std::string m_demoPath;
  std::string m_filenames[3];

};

#endif
