#include "Bench_TessellationPolyhedron2.h"
#include "../../Common.h"

#include <Inventor/helpers/SbFileHelper.h>

Bench_TessellationPolyhedron2::Bench_TessellationPolyhedron2(const std::string& name, int argc, char* argv[]) : 
Bench<MiTessellatedVolumeExtract,PEBIMesh>(name,"VolumeMeshPolyhedron",argc,argv) 
{
  m_polyhedralTessellator = MiTessellator::getNewTessellatorPolyhedron();

  SbString DataPath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshVizXLM/");
  m_demoPath = DataPath.toStdString() ;
  m_filenames[0] = "polySurf_1000.txt";
  m_filenames[1] = "polySurf_10000.txt";
  m_filenames[2] = "polySurf_100000.txt";
}

Bench_TessellationPolyhedron2::~Bench_TessellationPolyhedron2()
{
  delete m_polyhedralTessellator;
}

PEBIMesh* 
Bench_TessellationPolyhedron2::getMesh(size_t num, bool)
{
  return &m_reader.generate3D(m_demoPath + m_filenames[num]);
}

size_t
Bench_TessellationPolyhedron2::getNumCells() const
{
  return m_currentMesh->getTopology().getNumCells();
}

void
Bench_TessellationPolyhedron2::extract(MiTessellatedVolumeExtract* extractor, const CellFilter* cellFilter) const
{
  extractor->tessellate(*m_polyhedralTessellator,cellFilter);
}


