#ifndef _Bench_TessellationPolyhedron2_h
#define _Bench_TessellationPolyhedron2_h

#include "Bench.h"

#include <MeshVizXLM/extractors/MiTessellatedVolumeExtract.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

#include <mesh/volumes/PEBIMesh.h> 
#include <PEBIReader.h> 

#include <Inventor/STL/string>

template<>
inline MiTessellatedVolumeExtract*
Bench<MiTessellatedVolumeExtract,PEBIMesh>::getNewExtractor(PEBIMesh &mesh, bool parallel)
{
  return MiTessellatedVolumeExtract::getNewInstance(mesh,parallel);
}

class Bench_TessellationPolyhedron2 : public Bench<MiTessellatedVolumeExtract,PEBIMesh>
{
public:
  Bench_TessellationPolyhedron2(const std::string& name, int argc, char* argv[]);
  ~Bench_TessellationPolyhedron2();

private:
  virtual PEBIMesh* getMesh(size_t num, bool deadCells);
  virtual size_t    getNumCells() const;
  virtual void      extract(MiTessellatedVolumeExtract* extractor, const CellFilter* cellFilter) const;

  MiTessellator* m_polyhedralTessellator;

  mutable PEBIReader m_reader;
  std::string m_demoPath;
  std::string m_filenames[3];

};

#endif

