#include <MbSampleMeshBuilder.h>
#include <data/MbVec3SetI.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoStringSet.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIj.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoMeshLine.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/manips/SoClipPlaneManip.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Sample program"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 10
#define NUM_CELL_J 10
#define NUM_CELL_K 10

SoSwitch* m_vectorSwitch;
SoSwitch* m_skinSwitch;
SoSwitch* m_cellFilterSwitch;
static MbSampleMeshBuilder<MbVec3d,double> meshBuilder;
static int values[15] = { 0,0,0, 3,3,3, 5,5,5, 7,7,7, 9,9,9  };
static int num = 15;

#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>
class MyCellFilter : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t /*k*/) const 
  { 
    // Compute any random function 
    if (((NUM_CELL_I/3.0f)<i && i<=(2*NUM_CELL_I/3.0f)) && ((NUM_CELL_J/3.0f)<j && j<=(2*NUM_CELL_J/3.0f))) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};

class MyExtractorCallback : public MiExtractorCallback
{
public:
  void beginExtract(const std::string name, bool geomChanged, bool topoChanged, bool dataSetChanged, size_t) 
  {
    if(topoChanged)
    std::cout << name <<" topology computation started..." << endl;
    if(geomChanged)
    std::cout << name << " geometry computation started..." << endl;
    if(dataSetChanged)
    std::cout << name << " dataset computation started..." << endl;
  }
  void endExtract()
  {
    std::cout << "computation finished" << endl;
  }
  bool beginPhase(size_t , std::string , size_t ) { return true; }
  bool endPhase() { return true; }
  bool endStep(size_t ) { return true; }
  double getEndStepCallPeriod() { return 1.0; }
};

class UserData 
{
public:
  UserData(MoMesh *moMesh, MoScalarSetI *moScalarSetI, MoScalarSetIj *moScalarSetIj, MoScalarSetIjk *moScalarSetIjk, MoPredefinedColorMapping* colMap) :
      m_moMesh(moMesh), m_moScalarSetI(moScalarSetI), m_moScalarSetIj(moScalarSetIj), m_moScalarSetIjk(moScalarSetIjk), m_colMap(colMap) {}
    
  MoMesh * getMoMesh() { return m_moMesh; }
  MoScalarSetI *getMoScalarSetI() { return m_moScalarSetI;}
  MoScalarSetIj *getMoScalarSetIj() { return m_moScalarSetIj;}
  MoScalarSetIjk *getMoScalarSetIjk() { return m_moScalarSetIjk;}
  MoPredefinedColorMapping* getColorMap() { return m_colMap; }

private:
  MoMesh *m_moMesh;
  MoScalarSetI *m_moScalarSetI;
  MoScalarSetIj *m_moScalarSetIj;
  MoScalarSetIjk *m_moScalarSetIjk;
  MoPredefinedColorMapping* m_colMap;
};

class ItemNames : public MiStringSetIjk, public MiStringSetIj, public MiStringSetI
{
public:
  ItemNames() : m_timeStamp(MxTimeStamp::getTimeStamp()) {}
  virtual std::string get(size_t i, size_t j, size_t k) const
  {
    std::ostringstream ijkstring;
    ijkstring << m_prefix << i << "," << j << "," << k;
    return ijkstring.str();
  }
  virtual std::string get(size_t i, size_t j) const
  {
    std::ostringstream ijstring;
    ijstring << m_prefix << i << "," << j;
    return ijstring.str();
  }
  virtual std::string get(size_t i) const
  {
    std::ostringstream istring;
    istring << m_prefix << i;
    return istring.str();
  }
  virtual size_t getTimeStamp() const { return m_timeStamp; }
  virtual std::string getName() const { return ""; }
protected:
  std::string m_prefix;
  size_t m_timeStamp;
};

class CellNames : public ItemNames
{
public:
  CellNames() { m_prefix = "Cell: "; }
  virtual DataBinding getBinding() const { return PER_CELL; }
};

class NodeNames : public ItemNames
{
public:
  NodeNames() { m_prefix = "N: "; }
  virtual DataBinding getBinding() const { return PER_NODE; }
};

void
editSwitch(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *theSwitch = (SoSwitch*) (userData);
  if (theSwitch) {
    if (SO_KEY_PRESS_EVENT(ev, F)) 
    {
      theSwitch->whichChild = (theSwitch->whichChild.getValue() == SO_SWITCH_NONE) ? SO_SWITCH_ALL : SO_SWITCH_NONE;
    }
  }
  if (handled)
    eventCB->setHandled();
}

void
editCellShape(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshCellShape *cell = (MoMeshCellShape*) (userData);
  if (cell) {
    if (SO_KEY_PRESS_EVENT(ev, U)) 
    {
      float factor = cell->factor.getValue();
      cell->factor.setValue(factor + (float)0.01);
      handled = true;
    } 
    if (SO_KEY_PRESS_EVENT(ev, D)) 
    {
      float factor = cell->factor.getValue();
      cell->factor.setValue(factor - (float)0.01);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, C) )
    {
      cell->showCellName.setValue(cell->showCellName.getValue() == TRUE ? FALSE : TRUE);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, N) )
    {
      cell->showNodeName.setValue(cell->showNodeName.getValue() == TRUE ? FALSE : TRUE);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, E) )
    {
      cell->inclusiveList.setValue(cell->inclusiveList.getValue() == TRUE ? FALSE : TRUE);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, I) )
    {
      if(cell->cellIndices.getNum()>0)
        cell->cellIndices.setNum(0);
      else
        cell->cellIndices.setValues(0,15,values);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, P) )
    {
      if( num <15 ) num++;
      cell->cellIndices.setValues(0,num,values);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, M) )
    {
      if( num > 0 ) num--;
      cell->cellIndices.setNum(num);
      handled = true;
    }
  }
  if (handled)
    eventCB->setHandled();
}

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  UserData* myUserData = (UserData*) (userData);
  MoMesh *moMesh = myUserData->getMoMesh();
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, F1))
    {
      cout << "Displaying Tetrahedon mesh" << endl;
      MbVolumeMeshTetrahedron<MbVec3d,double,MbVec3d>* meshTetra = &meshBuilder.getMeshTetrahedron();
      moMesh->setMesh(meshTetra);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshTetra->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshTetra->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshTetra->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F2))
    {
      cout << "Displaying Hexahedron mesh" << endl;
      MbVolumeMeshHexahedron<MbVec3d,double,MbVec3d>* meshHexa = &meshBuilder.getMeshHexahedron(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshHexa);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshHexa->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshHexa->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshHexa->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F3))
    {
      cout << "Displaying Regular Volume mesh" << endl;
      MbVolumeMeshRegular<double,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F4))
    {
      cout << "Displaying Rectilinear Volume mesh" << endl;
      MbVolumeMeshRectilinear<double,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshRectilinear(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F5))
    {
      cout << "Displaying Curvilinear Volume mesh" << endl;
      MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshCurvilinear(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F7))
    {
      cout << "Displaying Hexahedron IJK mesh" << endl;
      MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>* meshUIjk = &meshBuilder.getHexahedronMeshIjk(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshUIjk);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshUIjk->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshUIjk->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshUIjk->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F8))
    {
      cout << "Displaying Quadrangle mesh" << endl;
      MbSurfaceMeshQuadrangle<MbVec3d,double,MbVec3d>* meshQuad = &meshBuilder.getSurfaceMeshQuadrangle(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),MbVec3d(1,0,0),MbVec3d(0,1,0));
      moMesh->setMesh(meshQuad);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshQuad->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshQuad->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshQuad->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 1;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F9))
    {
      cout << "Displaying Regular Surface mesh" << endl;
      MbSurfaceMeshRegular<double,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshRegular(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),MbVec3d(10,10,0));
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 1;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F10))
    {
      cout << "Displaying Rectilinear Surface mesh" << endl;
      MbSurfaceMeshRectilinear<double,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshRectilinear(NUM_CELL_I,NUM_CELL_J,0.0,0.0,10.0,10.0);
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 1;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F11))
    {
      cout << "Displaying Curvilinear Surface mesh" << endl;
      MbSurfaceMeshCurvilinear<MbVec3d,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshCurvilinear(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),MbVec3d(1,0,0),MbVec3d(0,1,0));
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 1;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, L))
    {
      cout << "Displaying Unstructured Line mesh" << endl;
      MbLineMeshUnstructured<MbVec3d,double,MbVec3d>* meshI = &meshBuilder.getLineMeshUnstructured(NUM_CELL_I,MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshI);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshI->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshI->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshI->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 2;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, K))
    {
      cout << "Displaying Curvilinear Line mesh" << endl;
      MbLineMeshCurvilinear<MbVec3d,double,MbVec3d>* meshI = &meshBuilder.getLineMeshCurvilinear(NUM_CELL_I,MbVec3d(0),MbVec3d(10));
      moMesh->setMesh(meshI);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshI->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshI->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshI->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = 2;
      handled = true;
    }
  }

  if (handled)
    eventCB->setHandled();

}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press F1 for Tetrahedon mesh" << endl;
  cout << "Press F2 for Hexahedron mesh" << endl;
  cout << "Press F3 for Regular mesh" << endl;
  cout << "Press F4 for Rectilinear mesh" << endl;
  cout << "Press F5 for Curvilinear mesh" << endl;
  cout << "Press F7 for Hexahedron IJK mesh" << endl;
  cout << "Press F8 for Quadrangle mesh" << endl;
  cout << "Press F9 for Regular Surface mesh" << endl;
  cout << "Press F10 for Rectilinear Surface mesh" << endl;
  cout << "Press F11 for Curvilinear Surface mesh" << endl;
  cout << "Press K   for Curvilinear Line mesh" << endl;
  cout << "Press L   for Unstructured Line mesh" << endl;
  cout << "Press u/d for scaling cells" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  cout << "Press c to toggle cell name visibility" << endl;
  cout << "Press n to toggle node name visibility (for unstructured mesh only)" << endl;
  cout << "Press e to toogle cell display" << endl;
  cout << "Press i to empty/fill the index list" << endl;
  cout << "Press p/m to increase/decrease the index list" << endl;
  cout << "Press f to enable/disable the cell filter (for IJK mesh only)" << endl;
  cout << "Displaying Regular mesh" << endl;


  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MbVolumeMeshRegular<double,double,MbVec3d> &meshIjk = meshBuilder.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3d(0),MbVec3d(10));

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&meshIjk);
  //moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  // Adjust range to scalar set 1
  colMap->minValue = (float)meshIjk.getScalarSetIjk(1)->getMin();
  colMap->maxValue = (float)meshIjk.getScalarSetIjk(1)->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // First Scalar Value
  MoScalarSetIjk *moScalarSetIjk = new MoScalarSetIjk;
  MoScalarSetIj *moScalarSetIj = new MoScalarSetIj;
  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetIjk->setScalarSet(meshIjk.getScalarSetIjk(1));
  sep->addChild(moScalarSetI);
  sep->addChild(moScalarSetIj);
  sep->addChild(moScalarSetIjk);

  // Name of each cell : this is used to each cell displayed by the cell shape
  MoStringSet *moCellStringSet = new MoStringSet;
  moCellStringSet->setStringSet(new CellNames);
  sep->addChild(moCellStringSet);

  // Name of each node : this is used to each node displayed by the cell shape
  MoStringSet *moNodeStringSet = new MoStringSet;
  moNodeStringSet->setStringSet(new NodeNames);
  sep->addChild(moNodeStringSet);

  m_cellFilterSwitch = new SoSwitch;
  m_cellFilterSwitch->whichChild = SO_SWITCH_NONE;
  sep->addChild(m_cellFilterSwitch);
  MoCellFilter* cellFilter = new MoCellFilter;
  cellFilter->setCellFilter(new MyCellFilter);
  m_cellFilterSwitch->addChild(cellFilter);

  MoDataBinding* dataBinding = new MoDataBinding;
  dataBinding->dataBinding = MoDataBinding::PER_NODE;
  sep->addChild(dataBinding);

  MyExtractorCallback ExtCB;

  // CellShape Section
  MoMeshCellShape *CellShape = new MoMeshCellShape;
  CellShape->setExtractorCallback(&ExtCB);
  CellShape->cellIndices.setValues(0,15,values);
  CellShape->factor.setValue(0.7f);
  CellShape->showCellName = TRUE;
  CellShape->showNodeName = TRUE;
  CellShape->offset = 0.05f;
  CellShape->relativeOffset = TRUE;
  sep->addChild(CellShape);

  // Use Scalar set 1 to color the CellShape
  CellShape->colorScalarSetId = 0;

  SoEventCallback *myCallbackNode1 = new SoEventCallback;
  UserData userData(moMesh,moScalarSetI,moScalarSetIj,moScalarSetIjk,colMap);
  myCallbackNode1->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, &userData); 
  sep->addChild(myCallbackNode1);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellShape, CellShape); 
  sep->addChild(myCallbackNode2);

  SoEventCallback *myCallbackNode3= new SoEventCallback;
  myCallbackNode3->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSwitch, m_cellFilterSwitch); 
  sep->addChild(myCallbackNode3);

  // Transparent Mesh Skin
  MoDrawStyle* style = new MoDrawStyle;
  style->displayEdges = true;
  style->displayFaces = false;
  sep->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  m_skinSwitch = new SoSwitch;
  m_skinSwitch->whichChild = 0;
  sep->addChild(m_skinSwitch);
  MoMeshSkin *skin = new MoMeshSkin;
  m_skinSwitch->addChild(skin);

  MoMeshSurface* meshSurface = new MoMeshSurface;
  meshSurface->colorScalarSetId = 0;
  m_skinSwitch->addChild(meshSurface);

  MoMeshLine* meshLine = new MoMeshLine;
  meshLine->colorScalarSetId = 0;
  m_skinSwitch->addChild(meshLine);

  // This mesh is used to connect the cells generated mesh as input of the vectors
  MoMesh* cellMesh = new MoMesh;
  cellMesh->connectFrom(CellShape);
  sep->addChild(cellMesh);
  
  Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)NUM_CELL_K),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetI *moVec3SetI = new MoVec3SetI;
  moVec3SetI->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetI);
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIjk);
  MoVec3SetIj *moVec3SetIj = new MoVec3SetIj;
  moVec3SetIj->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIj);

  // Display vector on grid
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  vector->thicknessFactor = 0.5f;
  m_vectorSwitch->addChild(vector);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

