#include "DemoCellShapeConnectedFromSkin.h"

#include <data/MbDataSet.h>

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/nodes/SoDepthOffset.h>
#include <Inventor/SoPickedPoint.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSet.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/details/MoFaceDetailI.h>
#include <MeshVizXLM/mapping/details/MoFaceDetailIjk.h>

using namespace::std;

//---------------------------------------------------------------------
DemoCellShapeConnectedFromSkin::DemoCellShapeConnectedFromSkin() :
Demo("MeshVizXLM CellShape connected from Skin",VOLUME_MESH_UNSTRUCTURED,ALL_VOLUME_MESHES_NO_TETRA,true),
m_indexAdaptor(m_defaultMeshSize[0],m_defaultMeshSize[1])
{
}

//---------------------------------------------------------------------
DemoCellShapeConnectedFromSkin::~DemoCellShapeConnectedFromSkin() 
{
  delete m_textEditor;
}

//---------------------------------------------------------------------
bool DemoCellShapeConnectedFromSkin::displayInstructions() const
{
  cout << "Click on the arrow icon then move the cursor over the mesh skin." << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoCellShapeConnectedFromSkin::mouseMoved(SoEventCallback *eventCB)
{
  const SoPickedPoint *pickedPoint = eventCB->getPickedPoint();
  if (pickedPoint) 
  {
    // something has been picked
    SbVec3f point = pickedPoint->getPoint();
    const SoDetail* detail = pickedPoint->getDetail();
    const MoMeshDetail* mdetail = NULL;
    size_t cellId[3] = { UNDEFINED_ID, UNDEFINED_ID, UNDEFINED_ID };
    size_t num = 1;
    double value = 0.0;
    if (detail->isOfType(MoFaceDetailI::getClassTypeId()))
    {
      // a face of an unstructured mesh representation has been picked
      // get detail from the picked face 
      MoFaceDetailI* fdetail = (MoFaceDetailI*) detail;  
      value = fdetail->getValue(point);
      mdetail = fdetail->getMeshDetail();
      // check if the face detail comes from the connected mesh to the skin
      const MeXSurfaceMeshUnstructured* connectedMesh = dynamic_cast< const MeXSurfaceMeshUnstructured*>(mdetail->getMesh());
      if (connectedMesh != NULL && connectedMesh->getTopology().hasInputCellMapping())
      {
        // use the input cell mapping from the extracted topology to retrieve the cell index in the original volume mesh
        cellId[0] = connectedMesh->getTopology().getInputCellIdI(fdetail->getCellIndex());
        cellId[1] = connectedMesh->getTopology().getInputCellIdJ(fdetail->getCellIndex());
        cellId[2] = connectedMesh->getTopology().getInputCellIdK(fdetail->getCellIndex());
        if (cellId[1] != UNDEFINED_ID)
          num = 3;
        else if (m_meshType != VOLUME_MESH_UNSTRUCTURED)
        { // When dealing with structured mesh, the J/K indices may be UNDEFINED_ID. This is a temporary limitation.
          // In that case, the I index is a flat index combining the 3 indices.
          // (see MeXTopologyI)
          m_indexAdaptor.getIjk(cellId[0],cellId[0],cellId[1],cellId[2]);
          num = 3;
        }
      }
      else
        cellId[0] = fdetail->getCellIndex();
    }
    else if (detail->isOfType(MoFaceDetailIjk::getClassTypeId()))
    {
      // a face of an structured volume mesh representation has been picked
      // get detail from the picked face 
      MoFaceDetailIjk* fdetail = (MoFaceDetailIjk*) detail;
      cellId[0] = fdetail->getCellIndexI();
      cellId[1] = fdetail->getCellIndexJ();
      cellId[2] = fdetail->getCellIndexK();
      num = 3;
      value = fdetail->getValue(point);
      mdetail = fdetail->getMeshDetail();
    }
    if (mdetail)
    {
      std::string colorName = mdetail->getColorScalarSet()->getName();
      // process the detail information retreived by picking
      m_textEditor->edit(cellId,num,value,m_meshType,colorName);
    }
    else
      // other Inventor shape
      m_textEditor->clear();
  }
  else 
    // nothing picked
    m_textEditor->clear();
  eventCB->setHandled();
}

//---------------------------------------------------------------------
void DemoCellShapeConnectedFromSkin::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = new MoDrawStyle;
  mat = new MoMaterial;
  ps->style = SoPickStyle::SHAPE;
  ds->displayFaces = true;
  ds->displayEdges = true;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor.setValue(SbColor(0.f,0.f,0.f));
}

//---------------------------------------------------------------------
void DemoCellShapeConnectedFromSkin::insertRepresentations(SoSeparator* sep)
{
  MoMaterial* mat = new MoMaterial;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor = SbColor(0,0,0);

  SoDepthOffset* depthOffset = new SoDepthOffset;
  depthOffset->offset = 0.02f;

  MoMesh* skinMesh = new MoMesh;
  this->connectToMeshRepresentation(skinMesh);

  const MbScalardSet* scalarSet = this->getScalarSet("$MyScalarSet");
  m_scalarsetNode = new MoScalarSet;
  m_scalarsetNode->setScalarSet(scalarSet);

  MoPredefinedColorMapping* colorMap = new MoPredefinedColorMapping;
  colorMap->predefColorMap = MoPredefinedColorMapping::TEMPERATURE;
  colorMap->minValue = float(scalarSet->getMin());
  colorMap->maxValue = float(scalarSet->getMax());

  MoMeshCellShape* cellShape = new MoMeshCellShape;
  cellShape->colorScalarSetId = 0;
  cellShape->factor = 0.7f;
  cellShape->inclusiveList = false;

  sep->addChild(skinMesh);
  sep->addChild(m_scalarsetNode);
  sep->addChild(new MoCellFilter);
  sep->addChild(colorMap);
  sep->addChild(depthOffset);
  sep->addChild(cellShape);
}

//---------------------------------------------------------------------
void 
  DemoCellShapeConnectedFromSkin::insertScene2D(SoSeparator* sep)
{
  m_textEditor = new TextSceneEditor(sep);
}

//---------------------------------------------------------------------
void 
  DemoCellShapeConnectedFromSkin::editInputMesh(SoEventCallback *eventCB)
{
  Demo::editInputMesh(eventCB);
  m_scalarsetNode->setScalarSet(this->getScalarSet("$MyScalarSet"));
}
