#ifndef _ClipLine_h
#define _ClipLine_h

#include <Inventor/SbVec.h>
#include <mesh/surfaces/MbSurfaceMeshCurvilinear.h>

class MoDrawStyle;
class MoMaterial;
class MoMeshClipLine;
class SoEventCallback;
class SoSeparator;
class SbString;

class ClipLine
{
public:
  ClipLine();
  ~ClipLine();

  int run();

  void onKeyPressed( SoEventCallback* eventCB );
  void onMousePressed( SoEventCallback* eventCB );

private:
  bool displayInstructions() const;
  SoSeparator* buildSceneGraph();

  bool readMesh( const SbString& topoFilename, const SbString& altitudeFilename, const SbString& scalarsetFilename );

  MbSurfaceMeshCurvilinear<MbVec3f, double, MbVec3f>* m_mesh;
  MoDrawStyle* m_ds;
  MoMaterial* m_mat;
  MoDrawStyle* m_cliplineDS;
  MoMeshClipLine* m_clipline;

  SbVec3f m_move;
};

#endif
