#include <MbSampleMeshBuilder.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshClipLine.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Sample program"

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 10
#define NUM_CELL_J 13
#define NUM_CELL_K 15

MoMeshClipLine* m_clipLine;
SoFieldSensor* m_directionSensor;

void
updateDirection( void* userData, SoSensor* /*sensor*/ )
{
  SoClipPlaneManip* manip = ( SoClipPlaneManip* )userData;
  m_clipLine->direction.setValue( manip->plane.getValue().getNormal() );
}

void
editScalarSet( void* /*userData*/, SoEventCallback* eventCB )
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  if ( SO_KEY_PRESS_EVENT( ev, NUMBER_0 ) )
  {
    m_clipLine->colorScalarSetId = 0;
    handled = true;
  }
  else if ( SO_KEY_PRESS_EVENT( ev, NUMBER_1 ) )
  {
    m_clipLine->colorScalarSetId = 1;
    handled = true;
  }
  else if ( SO_KEY_PRESS_EVENT( ev, NUMBER_2 ) )
  {
    m_clipLine->colorScalarSetId = 2;
    handled = true;
  }

  if (handled) 
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
  MbVolumeMeshHexahedron<MbVec3f,float,MbVec3f>* mesh = &meshBuilder.getMeshHexahedron(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K),MbVec3f(0),MbVec3f(10,10,10));

  cout << "Press 0 for per cell coloring" << endl;
  cout << "Press 1 for per node coloring" << endl;
  cout << "Press 2 for disabling coloring" << endl;

  MbVec3d max = mesh->getGeometry().getMax();
  MbVec3d min = mesh->getGeometry().getMin();

  MbVec3d center = ( max + min )/2.0f;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,0),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue((SbVec3f((float)center[0],(float)center[1],(float)center[2])));
  sep->addChild(manip);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(mesh);
  sep->addChild(moMesh);

  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)mesh->getScalarSet(1)->getMin();
  colMap->maxValue = (float)mesh->getScalarSet(1)->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::BLUE_RED;
  sep->addChild(colMap);

  // First Scalar Value
  MoScalarSetI *MoScalarSetI1 = new MoScalarSetI;
  MoScalarSetI1->setScalarSet(mesh->getScalarSet(0));
  sep->addChild(MoScalarSetI1);

  // Second Scalar Value
  MoScalarSetI *MoScalarSetI2 = new MoScalarSetI;
  MoScalarSetI2->setScalarSet(mesh->getScalarSet(1));
  sep->addChild(MoScalarSetI2);

  // Transparent Mesh Skin
  SoSeparator* skinSep = new SoSeparator;
  sep->addChild( skinSep );
  MoDrawStyle* style = new MoDrawStyle;
  style->displayFaces = TRUE;
  style->displayEdges = FALSE;
  skinSep->addChild( style );

  MoMaterial* mat = new MoMaterial;
  mat->faceColoring = MoMaterial::COLOR;
  mat->faceColor = SbColor( 0.f, 1.f, 1.f );
  mat->transparency = 0.8f;
  skinSep->addChild( mat );

  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  skinSep->addChild( pickStyle );

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = -1;
  skinSep->addChild( skin );

  // This mesh is used to connect the skin generated mesh as input of the clip line
  MoMesh* skinMesh = new MoMesh;
  skinMesh->connectFrom(skin);
  sep->addChild(skinMesh);

  MoMaterial* material = new MoMaterial;
  material->lineColoring = MoMaterial::CONTOURING;
  sep->addChild(material);

  // ClipLine
  m_clipLine = new MoMeshClipLine;
  sep->addChild( m_clipLine );
  m_clipLine->polyline.setValue( manip->draggerPosition.getValue() );
  m_clipLine->direction.setValue( manip->plane.getValue().getNormal() );
  // Use data set 0 for coloring
  m_clipLine->colorScalarSetId = 1;

  m_clipLine->polyline.connectFrom( &manip->draggerPosition );
  m_directionSensor = new SoFieldSensor( updateDirection, manip );
  m_directionSensor->attach( &manip->plane );

  SoEventCallback* myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback( SoKeyboardEvent::getClassTypeId(), editScalarSet );
  sep->addChild( myCallbackNode );

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->setTransparencyType( SoGLRenderAction::SORTED_PIXEL );
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

